package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.dto.BmInfoListDTO;
import com.bxm.localnews.merchant.dto.CategoryInfoDTO;
import com.bxm.localnews.merchant.dto.MerchantBmDetailDTO;
import com.bxm.localnews.merchant.param.BmEditParam;
import com.bxm.localnews.merchant.param.MerchantBmListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/7/14 20:26
 */

@Mapper
public interface BmManagerMapper {

    /**
     * 分页 获取
     * @param param
     * @return
     */
    List<BmInfoListDTO> getList(MerchantBmListParam param);

    /**
     * 插入数据
     *
     * @param param
     * @return
     */
    int insert(BmEditParam param);

    int update(BmEditParam param);

    /**
     * 获取社区分类信息
     *
     * @return
     */
    List<CategoryInfoDTO> getCategoryList();

    /**
     * 获取推荐位信息
     *
     * @param id 列表id
     * @return
     */
    MerchantBmDetailDTO detail(@Param("id") Long id);
}
