package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.dto.ActionRecordTraceIdDTO;
import com.bxm.localnews.merchant.dto.MerchantCounterClueDTO;
import com.bxm.localnews.merchant.dto.MerchantWeekReportDTO;
import com.bxm.localnews.merchant.entity.MerchantActionRecordEntity;
import com.bxm.localnews.merchant.param.MerchantCounterClueParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface MerchantActionRecordMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantActionRecordEntity record);

    int insertSelective(MerchantActionRecordEntity record);

    MerchantActionRecordEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantActionRecordEntity record);

    int updateByPrimaryKey(MerchantActionRecordEntity record);

    /**
     * 根据链路id获取行为信息
     *
     * @param traceId ： 链路id
     * @return
     */
    MerchantActionRecordEntity getByTraceId(@Param("traceId") String traceId);

    /**
     * 查询traceId，*只查这一个字段*，其他字段自己查找
     *
     * @return
     */
    String getTraceByRidBelonger(ActionRecordTraceIdDTO actionRecordTraceIdDTO);


    /**
     * 获取所有线索列表
     *
     * @param merchantCounterClueParam
     * @return
     */
    List<MerchantCounterClueDTO> getCluePageList(MerchantCounterClueParam merchantCounterClueParam);


    /**
     * 更新行为用户头像昵称
     *
     * @param actor    行为用户ID
     * @param headImg  头像
     * @param nickName 昵称
     * @return
     */
    int updateHeadImgAndNickNameByActor(@Param("actor") String actor, @Param("headImg") String headImg, @Param("nickName") String nickName);

    /**
     * 更新所属用户头像昵称
     *
     * @param belonger 所属用户ID
     * @param headImg
     * @param nickName
     * @return
     */
    int updateHeadImgAndNickNameByBelonger(@Param("belonger") Long belonger, @Param("headImg") String headImg, @Param("nickName") String nickName);

    /**
     * * 老板和员工的关系发生变化后进行action_record和content_record 更改relation_status状态
     *
     * @param userId : 要解绑的员工
     * @param status : 状态 0-解绑 1-绑定
     * @return
     */
    int updateRelationStatus(@Param("userId") Long userId, @Param("relationStatus") Byte status, @Param("merchantId") Long merchantId);

    /**
     * 获取所有商户的报表数据
     *
     * @param beginDate : 开始iriqi
     * @param endDate   : 结束日期
     * @return
     */
    List<MerchantWeekReportDTO> getReportList(@Param("beginDate") Date beginDate, @Param("endDate") Date endDate);

    /**
     * 获取所有用户的报表数据
     *
     * @param beginDate : 开始iriqi
     * @param endDate   : 结束日期
     * @return
     */
    List<MerchantWeekReportDTO> getEmployeeReportList(@Param("beginDate") Date beginDate, @Param("endDate") Date endDate);


}