package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.vo.MerchantAuthInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantAuthInfoMapper {

    MerchantAuthInfo selectByMerchantId(Long merchantId);




    /**
     * 根据商户ID查询对应的最后一次认证状态
     *
     * @param merchantIds 商户ID列表
     * @return 商户ID与最后一次的认证信息状态
     */
    List<MerchantAuthInfo> selectByMerchantIds(@Param("merchantIds") List<Long> merchantIds);

    //int insert(MerchantAuthInfo record);

    int insertSelective(MerchantAuthInfo record);

    int updateByPrimaryKeySelective(MerchantAuthInfo record);

}