package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.entity.MerchantCashFlowEntity;
import com.bxm.localnews.merchant.param.account.BossCashParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantCashFlowMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantCashFlowEntity record);

    int insertSelective(MerchantCashFlowEntity record);

    MerchantCashFlowEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantCashFlowEntity record);

    int updateByPrimaryKey(MerchantCashFlowEntity record);

    /**
     * 根据关联id 和类型 更改
     *
     * @param relationId 关联的id
     * @param type       原有的type
     * @param updateType 更新后的type
     * @param cashFlag   更新后的cashFlag
     * @param remark     更新后的remark 描述
     * @return
     */
    int update(@Param("relationId") Long relationId,
               @Param("type") String type,
               @Param("updateType") String updateType,
               @Param("cashFlag") Integer cashFlag,
               @Param("remark") String remark);

    /**
     * 获取商家流水
     *
     * @param param
     * @return
     */
    List<MerchantCashFlowEntity> merchantFlows(BossCashParam param);
}