package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.param.IndustryInfoParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
public interface MerchantCategoryMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantCategoryEntity record);

    int insertSelective(MerchantCategoryEntity record);

    MerchantCategoryEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantCategoryEntity record);

    int updateByPrimaryKey(MerchantCategoryEntity record);

    /**
     *
     * 获取行业所有信息列表
     * @param catName ：行业name
     * @param status : 状态
     * @return ： 返回列表信息
     */
    List<MerchantCategoryEntity> selectList(@Param("catName") String catName,@Param("status")Integer status);
    /**
     *
     * 获取行业信息列表
     *
     * @return ： 返回分页行业信息
     */
    List<MerchantCategoryEntity> selectPageList(IndustryInfoParam industryInfoParam);

    /**
     *
     * 查询所有行业列表
     *
     * @return ： 查询所有行业列表
     */
    List<MerchantCategoryEntity> selectAll();
}