package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.dto.MerchantCounterShareContentDTO;
import com.bxm.localnews.merchant.dto.MerchantMarketingDTO;
import com.bxm.localnews.merchant.entity.MerchantContentRecordEntity;
import com.bxm.localnews.merchant.param.MerchantCounterClueParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantContentRecordMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantContentRecordEntity record);

    int insertSelective(MerchantContentRecordEntity record);

    MerchantContentRecordEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantContentRecordEntity record);

    int updateByPrimaryKey(MerchantContentRecordEntity record);


    /**
     * 更新帖子的状态为下架
     *
     * @param relationId ： 帖子id
     * @return
     */
    int updateStatusByRelationId(@Param("relationId") Long relationId, @Param("status") Byte status);


    /**
     * * 老板和员工的关系发生变化后进行action_record和content_record 更改relation_status状态
     *
     * @param userId : 要解绑的员工
     * @param status : 状态 0-解绑 1-绑定
     * @return
     */
    int updateRelationStatus(@Param("userId") Long userId, @Param("merchantId") Long merchantId, @Param("relationStatus") Byte status);

    /**
     * 根据新闻/帖子 id和最终归属人 获取文章分享记录
     *
     * @param relationId ： 帖子id
     * @param belonger   ： 最终受益人 - 可能是分享人或者分享人的师傅，
     * @return : limit 1
     */
    MerchantContentRecordEntity selectByRelaIdBelonger(@Param("relationId") Long relationId, @Param("belonger") Long belonger, @Param("merchantId") Long merchantId);

    /**
     * 增加文章的** 次数，不同类型增加不同
     *
     * @param relationId ： 新闻/帖子 id
     * @param belonger   ： 归属人
     * @param type       ： 类型 0-分享 1-阅读 2-点击
     * @return
     */
    int addCounterByType(@Param("relationid") Long relationId, @Param("belonger") Long belonger, @Param("merchantId") Long merchantId, @Param("type") Integer type);


    /**
     * 获取我的营销文
     *
     * @param merchantCounterClueParam
     * @return
     */
    List<MerchantCounterShareContentDTO> getShareContentList(MerchantCounterClueParam merchantCounterClueParam);


    /**
     * 分页员工营销数据接口
     *
     * @param merchantCounterClueParam
     * @return
     */
    List<MerchantMarketingDTO> getMarketingTrends(MerchantCounterClueParam merchantCounterClueParam);

    /**
     * 首页获取营销数据 ： 获取最近10个
     *
     * @param merchantId : 商户id
     * @return
     */
    List<MerchantMarketingDTO> getMarketingTrendsTopTen(@Param("merchantId") Long merchantId);


}