package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.dto.goods.GoodLotteryManageDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantAllGoodsDTO;
import com.bxm.localnews.merchant.param.goods.ManageGoodsListParam;
import com.bxm.localnews.merchant.param.goods.QueryAllGoodsParam;
import com.bxm.localnews.merchant.vo.goods.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantGoodsMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(MerchantGoodsVo record);

    MerchantGoodsVo selectByPrimaryKey(Long id);

    MerchantGoodsVo getGoodsInfoById(Long id);

    MerchantGoodsVo selectByKeyAndMId(@Param("id") Long id, @Param("merchantId") Long merchantId);

    List<MerchantGoodsVo> selectByMerchantId(@Param("merchantId") Long merchantId, @Param("size") Integer size);

    GoodsSortVo selectTotalByMerchantId(@Param("merchantId") Long merchantId);

    GoodsSortVo selectSortByMerchantId(@Param("merchantId") Long merchantId);

    List<MerchantGoodsListVo> selectByqualification(QueryAllGoodsParam queryAllGoodsParam);

    List<MerchantGoodsListVo> selectByshelfType(QueryAllGoodsParam queryAllGoodsParam);

    List<MerchantGoodsListVo> selectByshelfAndSum(QueryAllGoodsParam queryAllGoodsParam);


    /**
     * 管理后台获取商品列表
     *
     * @param manageGoodsListParam 查询入参
     * @return 商品列表
     */
    List<GoodsListVo> getGoodsList(ManageGoodsListParam manageGoodsListParam);


    MerchantGoodstotalVo selectByqualificationTatal(Long merchantId);

    MerchantGoodstotalVo selectByshelfTypeTatal(@Param("shelfType") Integer shelfType, @Param("merchantId") Long merchantId);

    MerchantGoodstotalVo selectByshelfAndSumTatal(Long merchantId);


    int updateByPrimaryKeySelective(MerchantGoodsVo record);

    int updateByGoodsId(MerchantGoodsVo record);

    /**
     * 根据商品id获取商品的部分信息以及商家id和用户id
     *
     * @return ： 商品的部分信息以及商家id和用户id
     */
    GoodsInfoAndUserIdDTO getGoodsInfoAndMerchant(@Param("goodsId") Long goodsId);

    /**
     * 分页查询商品信息，仅返回商品ID
     *
     * @param start 查询起始
     * @param limit 查询数量
     * @return 商品ID列表
     */
    List<Long> queryByPage(@Param("start") int start, @Param("limit") int limit);

    /**
     * 下架商家所有商品
     *
     * @param merchantId
     * @return
     */
    int shelfDownAllGoods(Long merchantId);

    /**
     * 获取属于某个商家的所有正常商品信息
     *
     * @param merchantId 商家id
     * @return 商品ids
     */
    List<Long> getGoodIdsForMerchant(Long merchantId);

    /**
     * 便民页商品列表
     *
     * @param merchantId
     * @return
     */
    List<MerchantGoodsVo> getWorkGoodsList(Long merchantId);

    /**
     * 模糊匹配商品信息通过商品名称，为避免卡顿，这里限制返回20条，夺宝创建奖品用。
     *
     * @param goodsName 商品名称
     * @return 匹配商品列表
     */
    List<GoodLotteryManageDTO> matchGoodsByName(@Param("goodsName") String goodsName);

    /**
     * 获取所有商品通过商家id和商品类型
     *
     * @param merchantId 商家id
     * @param type       商品分类类型
     * @return 商品类别
     */
    List<MerchantAllGoodsDTO> getAllGoods(@Param("merchantId") Long merchantId,
                                          @Param("type") Integer type);

    /**
     * 更新商品的库存和总库存
     *
     * @param goodsId 商品ID
     * @param addNum  要增加的库存数和总库存数
     * @return 结果
     */
    int updateGoodsNumAndTotalNum(@Param("goodsId") Long goodsId,
                                  @Param("addNum") Integer addNum);

    /**
     * 更新商品的库存
     *
     * @param goodsId 商家id
     * @param num     商品购买的库存数
     * @return 结果
     */
    int updateGoodsNum(@Param("goodsId") Long goodsId,
                       @Param("num") Integer num);
}