package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.dto.MerchantCounterRankDTO;
import com.bxm.localnews.merchant.dto.MerchantCounterTotalDTO;
import com.bxm.localnews.merchant.entity.MerchantMemberCounterEntity;
import com.bxm.localnews.merchant.param.MerchantCounterRankParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantMemberCounterMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantMemberCounterEntity record);

    int insertSelective(MerchantMemberCounterEntity record);

    MerchantMemberCounterEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantMemberCounterEntity record);

    int updateByPrimaryKey(MerchantMemberCounterEntity record);

    int deleteByUserId(@Param("usreId") Long usreId);
    /**
     * 查询count保存信息
     *
     * @param merchantId ： 商户id
     * @param userId     ： 用户id
     * @return ： 单条记录，limit 1
     */
    MerchantMemberCounterEntity selectByMidUid(@Param("merchantId") Long merchantId, @Param("userId") Long userId);

    /**
     * 修改用户和商家的关系
     *
     * @param merchantId ： 商户id
     * @param userId     ： 用户id
     * @param relation   ： 状态0-解除 1-绑定
     * @return
     */
    int updateRelation(Long merchantId, Long userId, Byte relation);

    /**
     * 根据不同类型，增加不同统计数据的值
     *
     * @param merchantId       ： 商户id
     * @param userId           : 用户id
     * @param actionRecordType ： 不同的类型{@link com.bxm.localnews.merchant.common.enums.MerchantActionRecordTypeEnum}
     * @return ： 增加的结果
     */
    int addAmountByType(@Param("merchantId") Long merchantId, @Param("userId") Long userId, @Param("actionRecordType") Integer actionRecordType);

    /**
     * 首页排行榜信息 : 获取前三名的线索排行榜信息
     *
     * @param merchantId: 商户id
     * @return
     */
    List<MerchantCounterRankDTO> getRankTop(@Param("merchantId") Long merchantId);

    /**
     * 获取排行榜
     *
     * @param merchantCounterRankParam
     * @return
     */
    List<MerchantCounterRankDTO> getRankList(MerchantCounterRankParam merchantCounterRankParam);

    /**
     * 获取老板的排名信息
     *
     * @param bossUserId : 老板userId
     * @param type       : 类型 : 1-分享量 2-访问数 3-线索客户 4-订单数，默认是3线索数
     * @return
     */
    MerchantCounterRankDTO getBoosRank(@Param("userId") Long bossUserId, @Param("type") Integer type, @Param("merchantId") Long merchantId);

    /**
     * 获取我的贡献
     *
     * @param userId     : 用户id
     * @param type       ： 类型 0 - 我的贡献 1-员工贡献
     * @param merchantId ： 商户id
     * @return
     */
    MerchantCounterTotalDTO getUserContribution(@Param("userId") Long userId, @Param("type") Integer type, @Param("merchantId") Long merchantId);


    int addAmountByType(Long id, Integer actionRecordType);

    /**
     * 更新用户头像昵称
     *
     * @param userId
     * @param headImg
     * @param nickName
     * @return
     */
    int updateHeadImgAndNickName(@Param("userId") Long userId, @Param("headImg") String headImg, @Param("nickName") String nickName);
}