package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.entity.MerchantOpenvipOrderEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface MerchantOpenvipOrderMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantOpenvipOrderEntity record);

    int insertSelective(MerchantOpenvipOrderEntity record);

    MerchantOpenvipOrderEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantOpenvipOrderEntity record);

    int updateByPrimaryKey(MerchantOpenvipOrderEntity record);

    /**
     * 根据订单号查找商户的vip申请信息
     *
     * @param orderNo ： 订单号
     * @return ： 开通vip信息
     */
    MerchantOpenvipOrderEntity getByOrderNo(@Param("orderNo") String orderNo);

    /**
     * 根据id更改状态
     *
     * @param id     ： 支付的id
     * @param status ： 更改的状态
     * @return ： 更新的条数
     */
    int updateStatusById(@Param("id") Long id, @Param("status") Integer status);
}