package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.entity.MerchantPrerogativeInfoEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantPrerogativeInfoMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantPrerogativeInfoEntity record);

    int insertSelective(MerchantPrerogativeInfoEntity record);

    MerchantPrerogativeInfoEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantPrerogativeInfoEntity record);

    int updateByPrimaryKey(MerchantPrerogativeInfoEntity record);

    /**
     * 商户id获取权益信息
     *
     * @param merchantId      ： 商户id
     * @param prerogativeType ： 权益：0-vip 1-广告，可为空
     * @return
     */
    MerchantPrerogativeInfoEntity selectByMerchantId(@Param("merchantId") Long merchantId, @Param("prerogativeType") Integer prerogativeType);

    /**
     * 获取今天零点过期的权益信息
     *
     * @return ： 权益列表
     */
    List<MerchantPrerogativeInfoEntity> getTimeoutList();

    /**
     * 更新超时的权益信息
     *
     * @param ids ： 权益id
     * @return ： id 集合
     */
    int updateTimeoutInfo(List<Long> ids);
}