package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.dto.PromoteDetailDTO;
import com.bxm.localnews.merchant.entity.MerchantPromotionFlowEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

@Mapper
public interface MerchantUserPromotionFlowMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantPromotionFlowEntity record);

    int insertSelective(MerchantPromotionFlowEntity record);

    MerchantPromotionFlowEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantPromotionFlowEntity record);

    int updateByPrimaryKey(MerchantPromotionFlowEntity record);

    /**
     * 获取商户的推广金流水
     *
     * @param id ： 商户id
     * @return ： 流水列表
     */
    List<PromoteDetailDTO> getListByMerchantId(Long id);

    /**
     * 根据userId批量更新商户id
     *
     * @param merchantId ： 要更改的值
     * @param userId     ： 用户id
     * @return ： 更新的条数
     */
    int batchUpdateMerchantId(@Param("merchantId") Long merchantId, @Param("userId") Long userId);

    /**
     * 根据用户id，获取总流水
     *
     * @param : userId : 用户id
     * @return : 返回总流水金额。没有为0
     */
    BigDecimal getTotalAmountByUid(@Param("userId") Long userId);

    /**
     * 批量插入流水
     *
     * @param listEntity ： 流水记录
     * @return ： 插入结果
     */
    int batchInsertEntity(@Param("listEntity") List<MerchantPromotionFlowEntity> listEntity);
}