package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.entity.MerchantWithdrawFlow;
import com.bxm.localnews.merchant.entity.MerchantWithdrawManageFlow;
import com.bxm.localnews.merchant.param.MerchantWithdrawFlowListParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawManageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantWithdrawFlowExtendMapper extends MerchantWithdrawFlowMapper {

    /**
     * 根据请求参数获取C端的提现列表
     * @param param 请求参数
     * @return 提现列表
     */
    List<MerchantWithdrawFlow> selectByParam(MerchantWithdrawFlowListParam param);

    /**
     * 获取管理后台的提现列表
     * @param param 请求参数
     * @return 提现列表
     */
    List<MerchantWithdrawManageFlow> selectByManageParam(MerchantWithdrawManageParam param);

    /**
     * 更新提现流水状态
     * @param id 提现流水id
     * @param status 要更新为什么状态
     * @return
     */
    int updateStatue(@Param("id") Long id, @Param("status") Byte status);
}