package com.bxm.localnews.merchant.domain;

import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.param.PromoteParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserInviteHistoryMapper {
    /**
     * 插入邀请关系
     *
     * @param record ： 邀请信息
     * @return ： 返回结果
     */
    int insert(UserInviteHistoryEntity record);

    /**
     * 批量新增邀请记录
     *
     * @param listEntity ： 邀请记录
     * @return ： 新增结果
     */
    int batchInsert(@Param("listEntity") List<UserInviteHistoryEntity> listEntity);

    /**
     * 根据id 查询邀请记录
     *
     * @param id ： id
     * @return ： 返回邀请关系
     */
    UserInviteHistoryEntity selectByPrimaryKey(Long id);

    /**
     * 更新被邀请用户的VIP状态
     *
     * @param userId     被邀请人ID
     * @param activeType : 开通方式
     * @return 更新结果
     */
    int updateInvitedUserIdVip(@Param("userId") Long userId, @Param("activeType") String activeType);

    /**
     * 查询被邀请人的记录信息
     *
     * @param userId ： 用户id
     * @return
     */
    UserInviteHistoryEntity selectByUserId(@Param("userId") Long userId);

    /**
     * 更新师徒邀请关系
     *
     * @param userInviteHistoryBean
     * @return 更新结果条数
     */
    int updateInviteSelective(UserInviteHistoryEntity userInviteHistoryBean);

    /**
     * 分页获取邀请徒弟信息
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<UserInviteHistoryEntity> queryByPage(PromoteParam param);

    /**
     * 获取最近邀请的徒弟头像列表
     *
     * @param userId 用户ID
     * @param limit  查询数量
     * @return 徒弟头像列表
     */
    List<String> getLastInviteHeadImg(@Param("userId") Long userId, @Param("limit") int limit);

    /**
     * 更新邀请记录的标题字段
     *
     * @param entity 记录实体
     * @return 更新结果
     */
    int updateTitle(UserInviteHistoryEntity entity);

    /**
     * 查询relationId不为空，但是标题为空的记录
     *
     * @return 符合条件的记录
     */
    List<UserInviteHistoryEntity> queryEmptyTitleRecord();

}