package com.bxm.localnews.merchant.domain.goods;

import com.bxm.localnews.merchant.dto.goods.DiscountGroupFacadeDTO;
import com.bxm.localnews.merchant.dto.goods.MemberDayGoodsQueryDTO;
import com.bxm.localnews.merchant.dto.goods.MemberGoodsFacadeDTO;
import com.bxm.localnews.merchant.dto.goods.MemberGoodsManageListDTO;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsCategoryRelationEntity;
import com.bxm.localnews.merchant.param.goods.activity.MemberDayGoodsQueryParam;
import com.bxm.localnews.merchant.param.goods.manage.MemberDayGoodsManageQueryParam;
import com.bxm.localnews.merchant.vo.goods.activity.DiscountGroupGoodsVO;
import com.bxm.localnews.merchant.vo.goods.activity.MemberDayGoodsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface MerchantGoodsCategoryRelationMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantGoodsCategoryRelationEntity record);

    int insertSelective(MerchantGoodsCategoryRelationEntity record);

    MerchantGoodsCategoryRelationEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantGoodsCategoryRelationEntity record);

    int updateByPrimaryKey(MerchantGoodsCategoryRelationEntity record);

    /**
     * 查询商品分类信息通过商品id
     *
     * @param goodsId 商品id
     * @return 商品分类信息
     */
    List<MerchantGoodsCategoryRelationEntity> findCategoryByGoodsId(@Param("goodsId") Long goodsId);

    /**
     * 删除商品分类信息通过商品ID和分类类型
     *
     * @param goodsId 商品id
     * @param type    分类类型
     * @return 影响结果行数
     */
    int deleteByGoodsIdAndType(@Param("goodsId") Long goodsId,
                               @Param("type") Integer type);

    /**
     * 查询五折会员日商品
     *
     * @param param 入参
     * @return 五折会员日商品列表
     */
    List<MemberGoodsManageListDTO> getMemberDayGoodsList(MemberDayGoodsManageQueryParam param);

    /**
     * 获取分类信息通过商品id和分类类型
     *
     * @param goodsId 商品id
     * @param type    分类类型
     * @return 分类信息
     */
    MerchantGoodsCategoryRelationEntity getByGoodsIdAndType(@Param("goodsId") Long goodsId,
                                                            @Param("type") Integer type);

    /**
     * 更新具体分类商品的上下架状态
     *
     * @param goodsId 商品id
     * @param status  上下架状态
     * @param type    分类类型
     * @return 影响行数
     */
    int updateStatusByGoodsIdAndType(@Param("goodsId") Long goodsId,
                                     @Param("status") Integer status,
                                     @Param("type") Integer type);

    /**
     * 更新商品分类信息通过商品id和分类类型
     *
     * @param categoryUpdateEntity 商品分类信息
     * @return 影响记录行数
     */
    int updateSelectiveByGoodsIdAndType(MerchantGoodsCategoryRelationEntity categoryUpdateEntity);

    /**
     * 查询5折会员日商品列表
     *
     * @param queryDTO 查询入参
     * @return 5折会员日商品列表
     */
    List<MemberDayGoodsVO> getMemberDayGoodsQueryList(MemberDayGoodsQueryDTO queryDTO);

    /**
     * 分页查询5折会员日商品列表
     *
     * @param param 查询入参
     * @return 5折会员日商品列表
     */
    List<MemberDayGoodsVO> getMemberDayGoodsQueryPageList(MemberDayGoodsQueryParam param);

    /**
     * 获取优惠团购商品列表
     *
     * @param areaCode                   区域编码
     * @param queryType                  查询类型
     * @param industryId                 行业id
     * @param savePageDiscountGoodsCount 省钱页面展示数量
     * @return 优惠团购商品列表
     */
    List<DiscountGroupGoodsVO> getDiscountGroupGoodsList(@Param("areaCode") String areaCode,
                                                         @Param("queryType") Integer queryType,
                                                         @Param("industryId") Long industryId,
                                                         @Param("savePageDiscountGoodsCount") Integer savePageDiscountGoodsCount);

    /**
     * 获取最新的当前星期数的5折会员日商品
     *
     * @param areaCode  地区编码
     * @param weekCount 星期数
     * @return 最新的5折会员日商品
     */
    MemberGoodsFacadeDTO getLatestMemberDayGoods(@Param("areaCode") String areaCode,
                                                 @Param("weekCount") Integer weekCount);

    /**
     * 获取优先级最高的、最新的优惠团购商品信息
     *
     * @param areaCode 区域编码
     * @return 优惠团购商品信息
     */
    DiscountGroupFacadeDTO getLatestDiscountGroupGoods(@Param("areaCode") String areaCode);

    /**
     * 统计指定区域的会员日商品数量
     *
     * @param areaCode   地区编码
     * @param categoryId 行业分类id
     * @return 会员日商品数量
     */
    int countMemberDayGoodsCount(@Param("areaCode") String areaCode,
                                 @Param("categoryId") Long categoryId);

    /**
     * 统计指定区域的优惠团购商品数量
     *
     * @param areaCode   地区编码
     * @param categoryId 行业分类id
     * @return 优惠团购商品数量
     */
    int countDiscountGroupGoodsCount(@Param("areaCode") String areaCode,
                                     @Param("categoryId") Long categoryId);

    /**
     * 上架五折会员日
     *
     * @param date 当前时间
     */
    void updateMemberDayStatusOn(@Param("currDate") Date date);

    /**
     * 下架五折会员日
     *
     * @param date
     */
    void updateMemberDayStatusOff(@Param("currDate") Date date);

    /**
     * 获取商户五折会员日商品带size (配置为2个)
     *
     * @param merchantId 商户ID
     * @param size       阿波罗配置为2
     * @return 五折会员日
     */
    List<MemberDayGoodsVO> listMemberDayGoodsByMerchantId(@Param("merchantId") Long merchantId, @Param("size") Integer size);
}