package com.bxm.localnews.merchant.domain.goods;

import com.bxm.localnews.merchant.entity.goods.MerchantGoodsMemberDayEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantGoodsMemberDayMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MerchantGoodsMemberDayEntity record);

    int insertSelective(MerchantGoodsMemberDayEntity record);

    MerchantGoodsMemberDayEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantGoodsMemberDayEntity record);

    int updateByPrimaryKey(MerchantGoodsMemberDayEntity record);

    /**
     * 查询会员日日期信息通过商品id
     *
     * @param goodsId 商品id
     * @return 会员日日期信息
     */
    List<MerchantGoodsMemberDayEntity> getListByGoodsId(@Param("goodsId") Long goodsId);

    /**
     * 删除星期信息通过商品id
     *
     * @param goodsId 商品id
     * @return 影响记录数
     */
    int deleteByGoodsId(@Param("goodsId") Long goodsId);
}