package com.bxm.localnews.merchant.domain.goods;


import com.bxm.localnews.merchant.entity.goods.MerchantGoodsSpecs;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MerchantGoodsSpecsMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(MerchantGoodsSpecs record);

    MerchantGoodsSpecs selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MerchantGoodsSpecs record);

    List<MerchantGoodsSpecs> getGoodsSpecsList(@Param("goodsId") Long goodsId);

    int batchInsert(@Param("specsList") List<MerchantGoodsSpecs> merchantGoodsSpecs);

    /**
     * 根据商品id删除规格信息
     *
     * @param goodsId 商品id
     * @return 返回结果
     */
    int delSpecsInfoByGoodsId(@Param("goodsId") Long goodsId);

    /**
     * 根据id更新规格库存
     *
     * @param id     id
     * @param addNum 增加的库存数
     * @return 更新结果
     */
    int updateGoodsNumAndTotalNum(@Param("id") Long id,
                                  @Param("addNum") Integer addNum);

    /**
     * 更新商品的库存
     *
     * @param id  id
     * @param num 商品购买的库存数
     * @return 结果
     */
    int updateGoodsNum(@Param("id") Long id,
                       @Param("num") Integer num);

    /**
     * 运营后台获取商品规格
     *
     * @param goodsId goodsId
     * @return 结果
     */
    List<MerchantGoodsSpecs> manageGoodsSpecsList(@Param("goodsId") Long goodsId);
}