package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.common.properties.MerchantGoodsRateProperties;
import com.bxm.localnews.merchant.domain.UserInviteHistoryMapper;
import com.bxm.localnews.merchant.dto.MerchantOpenVipDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.param.MerchantOrderInfoParam;
import com.bxm.localnews.merchant.service.UserInviteService;
import com.bxm.localnews.merchant.service.account.boss.BossAccountActionService;
import com.bxm.localnews.merchant.service.account.boss.handle.BossAccountContext;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.localnews.merchant.service.promote.PromoteService;
import com.bxm.localnews.merchants.dto.MerchantUserDTO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.facade.service.MerchantRedisRefreshFacade;
import com.bxm.localnews.merchants.vo.MerchantInfoSimpleVO;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author pf.w
 * @date 2020/7/16 11:55
 */
@Api(tags = "11-90 [内部接口]用户信息相关接口")
@RequestMapping("facade/merchant")
@RestController
@Slf4j
public class MerchantFacadeController {

    private final UserInviteService userInviteService;

    private final MerchantInfoFacadeService merchantInfoService;

    private final UserInviteHistoryMapper userInviteHistoryMapper;

    private final MerchantRedisRefreshFacade merchantRedisRefresh;

    private final MerchantGoodsRateProperties merchantGoodsRateProperties;

    private BossAccountActionService bossAccountActionService;

    private final GoodsService goodsService;

    private final MerchantOrderInfoService merchantOrderInfoService;

    private final PromoteService promoteService;

    @Autowired
    public MerchantFacadeController(UserInviteService userInviteService,
                                    MerchantInfoFacadeService merchantInfoService,
                                    UserInviteHistoryMapper userInviteHistoryMapper,
                                    MerchantRedisRefreshFacade merchantRedisRefresh,
                                    MerchantGoodsRateProperties merchantGoodsRateProperties,
                                    BossAccountActionService bossAccountActionService, GoodsService goodsService, MerchantOrderInfoService merchantOrderInfoService, PromoteService promoteService) {
        this.userInviteService = userInviteService;
        this.merchantInfoService = merchantInfoService;
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.merchantRedisRefresh = merchantRedisRefresh;
        this.merchantGoodsRateProperties = merchantGoodsRateProperties;
        this.bossAccountActionService = bossAccountActionService;
        this.goodsService = goodsService;
        this.merchantOrderInfoService = merchantOrderInfoService;
        this.promoteService = promoteService;
    }


    @ApiOperation(value = "11-90-02 新增商户收徒信息", notes = "新增商户收徒信息")
    @PostMapping("/insertMerchantInvite")
    public ResponseEntity<Boolean> insertMerchantInvite(@RequestBody UserInviteHistoryEntity userInviteHistoryEntity) {
        return ResponseEntity.ok(userInviteService.insert(userInviteHistoryEntity));
    }

    @ApiOperation(value = "11-90-03 提供给管理后台注销账号使用", notes = "删除商家信息")
    @GetMapping("/deleteMerchantInfo")
    public ResponseEntity<Boolean> deleteMerchantInfo(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(merchantInfoService.deleteMerchantInfoByUid(userId));
    }

    @ApiOperation(value = "11-90-04 更新用户收徒的VIP状态", notes = "当激活VIP时，需要去更新VIP状态")
    @GetMapping("/updateInvitedUserIdVip")
    public ResponseEntity<Boolean> updateInvitedUserIdVip(@RequestParam("userId") Long userId, @RequestParam("activeType") String activeType) {
        return ResponseEntity.ok(userInviteHistoryMapper.updateInvitedUserIdVip(userId, activeType) > 0);
    }

    @ApiOperation(value = "11-90-05 获取用户的商户状态", notes = "判断用户是否商户，如果是商户则返回商户相关信息")
    @GetMapping("userMerchant")
    public ResponseEntity<MerchantUserDTO> userMerchant(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(merchantRedisRefresh.getMerchantUserCache(userId));
    }

    @ApiOperation("11-90-05 获取商家商品比率")
    @GetMapping("/getMerchantGoodsRateProperties")
    public ResponseEntity<MerchantGoodsRateProperties> getMerchantRateProperties() {
        return ResponseEntity.ok(merchantGoodsRateProperties);
    }

    @ApiOperation("11-90-06 商家账户操作")
    @PostMapping("operatorMerchantAccount")
    public ResponseEntity<Boolean> operatorMerchantAccount(@RequestBody BossAccountContext accountContext) {
        bossAccountActionService.bossAccountActionLogic(accountContext);
        return ResponseEntity.ok(true);
    }

    @ApiOperation("11-90-07 获取商品信息:这个方法远比你看到的注释功能还要多哦~~~~")
    @GetMapping("/getGoodsInfoById")
    public ResponseEntity<GoodsInfoAndUserIdDTO> getMerchantGoodsById(Long goodsId) {
        return ResponseEntity.ok(goodsService.getByGoodsId(goodsId));
    }

    /**
     * 退还商品数量
     *
     * @param goodsId
     * @param num
     * @return
     */
    @GetMapping("/returnGoodsNum")
    @ApiOperation("11-90-08 退还商品数量")
    public ResponseEntity<Boolean> returnGoodsNum(@RequestParam("goodsId") Long goodsId, @RequestParam("num") Long num) {
        return ResponseEntity.ok(goodsService.stockGoods(goodsId, num.intValue()));
    }

    /**
     * 新增商家商品订单
     *
     * @param merchantOrderInfoParam : 商家订单信息
     * @return ： 订单新增结果
     */
    @PostMapping("/addMerchantOrder")
    @ApiOperation("11-90-09 新增商家商品订单")
    public ResponseEntity<Boolean> addMerchantOrder(@RequestBody MerchantOrderInfoParam merchantOrderInfoParam) {
        return ResponseEntity.ok(merchantOrderInfoService.insertBySelect(merchantOrderInfoParam) > 0);
    }

    /**
     * 根据订单号修改商家的 订单信息
     *
     * @param merchantOrderInfoParam : 订单信息
     * @return ： 更新结果
     */
    @PostMapping("/updateMerchantOrderByNo")
    @ApiOperation("11-90-10 根据订单号修改商家的 订单信息")
    public ResponseEntity<Boolean> updateMerchantOrder(@RequestBody MerchantOrderInfoParam merchantOrderInfoParam) {
        return ResponseEntity.ok(merchantOrderInfoService.updateByOrderNoSelect(merchantOrderInfoParam) > 0);
    }

    /**
     * 开通商家VIP权益
     *
     * @return
     */
    @PostMapping("/openMerchantVip")
    @ApiOperation("11-90-11 开通商家VIP权益")
    public ResponseEntity<MerchantOpenVipDTO> openMerchantVip(@RequestParam("merchantId") Long merchantId, @RequestParam("userId") Long userId) {
        return ResponseEntity.ok(merchantOrderInfoService.openMerchantVip(merchantId, userId));
    }

    @ApiOperation("11-90-12 商家权益支付成功回调")
    @GetMapping("/paySuccessCallback")
    public ResponseEntity<Boolean> paySuccessCallback(@RequestParam("orderNo") String orderNo) {
        return ResponseEntity.ok(merchantOrderInfoService.paySuccessCallback(orderNo));
    }

    @ApiOperation("11-90-13 根据商品id获取商户的简易信息")
    @GetMapping("/getMerchantInfoSimpleInfo")
    public ResponseEntity<MerchantInfoSimpleVO> getMerchantInfoSimpleInfo(@RequestParam("goodsId") Long goodsId) {
        return ResponseEntity.ok(goodsService.getSimpleMerchantInfoByGoodsId(goodsId));
    }

    @ApiOperation("11-90-14 扣除商家订单库存")
    @GetMapping("/subOrderNum")
    public ResponseEntity<Boolean> subOrderNum(@RequestParam("goodsId") Long goodsId, @RequestParam("num") Integer num) {
        return ResponseEntity.ok(goodsService.stockGoods(goodsId, num));
    }
    @ApiOperation("11-90-15 校验商品是否可以购买")
    @GetMapping("/checkGoodsStatus")
    public ResponseEntity<Message> checkGoodsStatus(@RequestParam("goodsId") Long goodsId, @RequestParam("num") Integer num,
                                                    @RequestParam("userId") Long userId) {
        return ResponseEntity.ok(goodsService.checkGoodsStatus(goodsId, num, userId));
    }
}
