package com.bxm.localnews.merchant.model.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jieliGG
 * @date 2020/9/1 14:24
 **/
@Data
public class MerchantOrderInfoDTO {

    private String orderNo;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户昵称
     */
    private String userName;

    /**
     * 用户手机号码
     */
    private String userPhone;

    /**
     * 用户实际支付金额
     */
    private BigDecimal payMoney;

    /**
     * 商家实际到账金额
     */
    private BigDecimal receiveMoney;

    /**
     * 第三方收取服务费
     */
    private BigDecimal serviceMoney;

    /**
     * 商家推广费用[佣金]
     */
    private BigDecimal promotionMoney;

    /**
     * 下单时间
     */
    private Date createTime;

    /**
     * 支付成功时间
     */
    private Date payTime;

    /**
     * 订单状态[0:代付款 1-已付款待使用 2:已核销 3：退单待确认 4：退单中 5退单成功 6：订单未支付过期 ]
     */
    private Integer state;

    /**
     * 核销时间
     */
    private Date verificationTime;

}
