/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.dto.IndustryDTO;
import com.bxm.localnews.merchant.param.IndustryInfoParam;
import com.bxm.localnews.merchant.param.IndustryOperatorParam;
import com.bxm.localnews.merchant.service.IndustryService;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/7/9 22:44
 */
@RestController
@Api(tags = "11-52 行业信息")
@RequestMapping("/manage/merchant/industry")
public class IndustryController {


    private IndustryService industryService;

    @Autowired
    public IndustryController(IndustryService industryService) {
        this.industryService = industryService;
    }

    @ApiOperation("11-52-01 获取全部列表")
    @GetMapping("getList")
    public ResponseJson<List<IndustryDTO>> getAllList(IndustryInfoParam industryInfoParam){
        return ResponseJson.ok(industryService.getListAll(industryInfoParam));
    }
    @ApiOperation("11-52-02 获取分页列表")
    @GetMapping("getPageList")
    public ResponseJson<PageWarper<IndustryDTO>> getPageList(IndustryInfoParam industryInfoParam){
        return ResponseJson.ok(industryService.getListPage(industryInfoParam));
    }

    @ApiOperation("11-52-03 获取行业详情信息")
    @GetMapping("getById")
    public ResponseJson<IndustryDTO> getById(Long id) {

        return ResponseJson.ok(industryService.getById(id));
    }


    @ApiOperation("11-52-04 修改价格")
    @PostMapping("updatePrice")
    public ResponseJson<Boolean> updatePrice(@RequestBody IndustryOperatorParam industryOperatorParam){
        return ResponseJson.ok(industryService.updatePrice(industryOperatorParam));
    }
}
