/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.manage.controller;


import com.bxm.localnews.merchant.param.MerchantOpenVipParam;
import com.bxm.localnews.merchant.service.InterestsService;
import com.bxm.localnews.merchants.dto.InterestsInfoDTO;
import com.bxm.localnews.merchants.param.InterestsInfoParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : jieli.xu
 * @date 2020/7/9 22:18
 * 权益接口
 */
@RestController
@RequestMapping("/manage/merchant/interests")
@Api(tags = "11-51 权益管理")
public class InterestsController {

    private InterestsService interestsService;

    @Autowired
    public InterestsController(InterestsService interestsService) {
        this.interestsService = interestsService;
    }

    @ApiOperation("11-51-01 获取列表")
    @GetMapping("getList")
    public ResponseJson<PageWarper<InterestsInfoDTO>> getPageList(InterestsInfoParam interestsInfoParam) {

        return ResponseJson.ok(interestsService.getPageList(interestsInfoParam));
    }

    @ApiOperation("11-51-02 根据手机号获取信息")
    @ApiImplicitParam(name = "phone", value = "手机号")
    @GetMapping("getByPhone")
    public ResponseJson<InterestsInfoDTO> getByPhone(String phone) {
        return ResponseJson.ok(interestsService.getByPhone(phone));
    }

    @ApiOperation("11-51-03 开通会员")
    @PostMapping("openVip")
    public ResponseJson<Boolean> openVip(@RequestBody MerchantOpenVipParam merchantOpenVipParam) {
        if (Objects.equals(merchantOpenVipParam.getInterestsType(), 2)) {
            return ResponseJson.build(Message.build(false).setMessage("暂未开通此功能"));
        }
        return ResponseJson.ok(interestsService.openVip(merchantOpenVipParam, 0));
    }

    @ApiOperation("11-51-04 修改备注")
    @PostMapping("updateRemark")
    public ResponseJson<Boolean> updateRemark(@RequestBody MerchantOpenVipParam merchantOpenVipParam) {
        return ResponseJson.ok(interestsService.updateRemark(merchantOpenVipParam));
    }

}
