package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.param.CategoryCreateParam;
import com.bxm.localnews.merchant.service.CategoryService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: zhoujincheng
 * @create: 2020-08-25 17:08
 */
@Api(tags = "11-09 行业接口API")
@RestController
@RequestMapping("/manage/merchant/category")
public class MerchantCategoryController {

    @Autowired
    private CategoryService categoryService;

    @ApiOperation(value = "11-09-1 【v1】新增行业类型", notes = "新增行业类型", httpMethod = "POST")
    @PostMapping("/create")
    public ResponseJson create(@RequestBody @Validated CategoryCreateParam categoryCreateParam) {
        return ResponseJson.build(categoryService.create(categoryCreateParam));
    }
}
