package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.coupon.service.CouponInfoService;
import com.bxm.localnews.merchant.dto.coupon.ManageCouponDetailDTO;
import com.bxm.localnews.merchant.dto.coupon.ManageCouponItemDTO;
import com.bxm.localnews.merchant.dto.coupon.MerchantCouponUsableDTO;
import com.bxm.localnews.merchant.entity.Tuple;
import com.bxm.localnews.merchant.param.coupon.ManageCouponCreateParam;
import com.bxm.localnews.merchant.param.coupon.ManageCouponQueryParam;
import com.bxm.localnews.merchant.param.coupon.ManageCouponStatusParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author liujia
 * @date 2020-09-21 21:20
 **/
@Api(tags = "11-55 运营后台优惠券管理")
@RestController
@RequestMapping("manage/merchant/coupon")
public class MerchantCouponManageController {

    private final CouponInfoService couponInfoService;

    @Autowired
    public MerchantCouponManageController(CouponInfoService couponInfoService) {
        this.couponInfoService = couponInfoService;
    }

    @ApiOperation("11-55-01 分页查询优惠券")
    @GetMapping("query")
    public ResponseJson<PageWarper<ManageCouponItemDTO>> query(ManageCouponQueryParam param) {
        return ResponseJson.ok(couponInfoService.queryByPage(param));
    }

    @ApiOperation("11-55-02 获取查询条件中的状态类型")
    @GetMapping("status")
    public ResponseJson<List<Tuple>> getStatusList() {
        return ResponseJson.ok(couponInfoService.getCouponStatusList());
    }

    @ApiOperation("11-55-03 更新优惠券的状态")
    @PostMapping("change")
    public ResponseJson changeStatus(@RequestBody ManageCouponStatusParam param) {
        return ResponseJson.build(couponInfoService.changeStatusWithManage(param));
    }

    @ApiOperation("11-55-04 创建或编辑优惠券")
    @PostMapping("create")
    public ResponseJson create(@RequestBody ManageCouponCreateParam param) {
        return ResponseJson.build(couponInfoService.saveCouponWithManage(param));
    }

    @ApiOperation("11-55-05 获取优惠券详情")
    @ApiImplicitParam(name = "couponId", value = "优惠券ID")
    @GetMapping("detail")
    public ResponseJson<ManageCouponDetailDTO> getStatusList(Long couponId) {
        return ResponseJson.ok(couponInfoService.getCouponDetailWithManage(couponId));
    }

    @ApiOperation("11-55-06 获取商户所属所有可用优惠券信息")
    @ApiImplicitParam(name = "merchantId", value = "商户id")
    @GetMapping("queryUsableCoupon")
    public ResponseJson<List<MerchantCouponUsableDTO>> getCouponListByMerchantId(@RequestParam("merchantId") Long merchantId) {
        return ResponseJson.ok(couponInfoService.getCouponListByMerchantId(merchantId));
    }
}
