/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.dto.MerchantManageOrderInfoDTO;
import com.bxm.localnews.merchant.param.MerchantManageOrderParam;
import com.bxm.localnews.merchant.service.order.MerchantOrderInfoService;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author jieliGG
 * @date 2020/9/1 17:24
 **/
@Api(tags = "11-13 管理后台商户订单管理")
@RestController
@AllArgsConstructor
@RequestMapping("manage/merchant/order")
public class MerchantManageOrderController {

    private final MerchantOrderInfoService merchantOrderInfoService;

    @ApiOperation(value = "11-13-01 [v1]管理后台 - 获取订单列表")
    @GetMapping("/getManageOrderList")
    public ResponseJson<PageWarper<MerchantManageOrderInfoDTO>> getList(MerchantManageOrderParam merchantManageOrderParam) {
        return ResponseJson.ok(merchantOrderInfoService.getManagePageListOrder(merchantManageOrderParam));
    }
}
