/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.param.ManageMerchantWithdrawParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawManageParam;
import com.bxm.localnews.merchant.service.withdraw.MerchantWithdrawService;
import com.bxm.localnews.merchant.vo.MerchantWithdrawManageFlowVO;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author jieliGG
 * @date 2020/9/1 17:24
 **/
@Api(tags = "11-14 管理后台提现管理")
@RestController
@AllArgsConstructor
@RequestMapping("manage/merchant/withdraw")
public class MerchantManageWithdrawController {

    private final MerchantWithdrawService merchantWithdrawService;

    @ApiOperation(value = "11-14-01 管理后台获取提现列表")
    @GetMapping("getList")
    public ResponseJson<PageWarper<MerchantWithdrawManageFlowVO>> getList(MerchantWithdrawManageParam param) {
        return ResponseJson.ok(merchantWithdrawService.getManageListByParam(param));
    }

    @ApiOperation(value = "11-14-02 提现的相关操作", notes = "包括通过，延迟审核和拒绝通过")
    @PostMapping("passWithdraw")
    public ResponseJson passWithdraw(@RequestBody @Validated ManageMerchantWithdrawParam param) {
        return ResponseJson.build(merchantWithdrawService.passWithdraw(param));
    }


}
