/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.dto.goods.GoodLotteryManageDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsSampleListDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantAllGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.QueryGoodsManageDTO;
import com.bxm.localnews.merchant.param.GoodsIdManageParamFail;
import com.bxm.localnews.merchant.param.goods.GoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.GoodsIdManageParam;
import com.bxm.localnews.merchant.param.goods.GoodsPosterParam;
import com.bxm.localnews.merchant.param.goods.GoodsSampleListParam;
import com.bxm.localnews.merchant.param.goods.GoodsUpdateManageParam;
import com.bxm.localnews.merchant.param.goods.ManageGoodsListParam;
import com.bxm.localnews.merchant.param.goods.updateGoodsSampleParam;
import com.bxm.localnews.merchant.service.goods.GoodsManageService;
import com.bxm.localnews.merchant.vo.goods.GoodsListVo;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"11-54  \u540e\u53f0\u5546\u54c1\u76f8\u5173API"})
@RestController
@RequestMapping(value={"/manage/merchant/goods/"})
public class GoodsManageController {
    @Autowired
    private GoodsManageService goodsManageService;

    @GetMapping(value={"/goodsList"})
    @ApiOperation(value="11-54-1  \u5546\u54c1\u5217\u8868", notes="\u5546\u54c1\u5217\u8868", httpMethod="GET")
    public ResponseJson<PageWarper<GoodsListVo>> getGoodsList(ManageGoodsListParam manageGoodsListParam) {
        return ResponseJson.ok((Object)this.goodsManageService.getMerchantList(manageGoodsListParam));
    }

    @ApiOperation(value="11-54-2 \u5ba1\u6838\u901a\u8fc7", notes="\u5ba1\u6838\u901a\u8fc7", httpMethod="POST")
    @PostMapping(value={"/auditSuccess"})
    public ResponseJson<Boolean> auditSuccess(@RequestBody @Validated GoodsIdManageParam goodsIdManageParam) {
        Message message = this.goodsManageService.auditSuccess(goodsIdManageParam);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-54-3 \u5ba1\u6838\u62d2\u7edd", notes="\u5ba1\u6838\u62d2\u7edd", httpMethod="POST")
    @PostMapping(value={"/auditFail"})
    public ResponseJson<Boolean> auditFail(@RequestBody @Validated GoodsIdManageParamFail goodsIdManageParamFail) {
        Message message = this.goodsManageService.auditFail(goodsIdManageParamFail);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-54-4 \u67e5\u770b\u5546\u54c1\u8be6\u60c5", notes="\u67e5\u770b\u5546\u54c1\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/queryGoods"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="goodsId", value="\u5546\u54c1id", required=true)})
    public ResponseJson<QueryGoodsManageDTO> queryGoods(@RequestParam(value="goodsId") Long goodsId) {
        Message message = this.goodsManageService.queryGoods(goodsId);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("queryGoodsManageDTO"));
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-54-5 \u4fee\u6539\u5546\u54c1", notes="\u4fee\u6539\u5546\u54c1", httpMethod="POST")
    @PostMapping(value={"/update"})
    public ResponseJson<Boolean> update(@RequestBody @Validated GoodsUpdateManageParam goodsUpdateManageParam) {
        Message message = this.goodsManageService.update(goodsUpdateManageParam);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @GetMapping(value={"/goodsSampleList"})
    @ApiOperation(value="11-54-6  \u793a\u4f8b\u5546\u54c1\u5217\u8868", notes="\u793a\u4f8b\u5546\u54c1\u5217\u8868", httpMethod="GET")
    public ResponseJson<PageWarper<GoodsSampleListDTO>> getGoodsSampleList(@Validated GoodsSampleListParam goodsSampleListParam) {
        return ResponseJson.ok((Object)this.goodsManageService.getGoodsSampleList(goodsSampleListParam));
    }

    @ApiOperation(value="11-54-7 \u4fee\u6539\u793a\u4f8b\u5546\u54c1", notes="\u4fee\u6539\u5546\u54c1", httpMethod="POST")
    @PostMapping(value={"/updateGoodsSample"})
    public ResponseJson<Boolean> updateGoodsSample(@RequestBody @Validated updateGoodsSampleParam updateGoodsSampleParam2) {
        Message message = this.goodsManageService.updateGoodsSample(updateGoodsSampleParam2);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-54-8 \u65b0\u589e\u5546\u54c1", notes="\u65b0\u589e\u5546\u54c1", httpMethod="POST")
    @PostMapping(value={"/create"})
    public ResponseJson<Boolean> createManger(@RequestBody @Validated GoodsCreateParam goodsCreateParam) {
        Message message = this.goodsManageService.create(goodsCreateParam);
        if (message.isSuccess()) {
            ResponseJson.ok((Object)message.getLastMessage());
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-54-9 \u65b0\u589e\u5546\u54c1\u6d77\u62a5\u5e76\u4e0a\u4e0b\u67b6", notes="\u65b0\u589e\u5546\u54c1\u6d77\u62a5\u5e76\u4e0a\u4e0b\u67b6", httpMethod="POST", nickname="\u803f\u6768\u6768")
    @PostMapping(value={"/saveOrUpdateGoodsPoster"})
    public ResponseJson<Message> saveOrUpdateGoodsPoster(@RequestBody @Validated GoodsPosterParam goodsCreateParam) {
        Message message = this.goodsManageService.saveOrUpdateGoodsPoster(goodsCreateParam);
        return ResponseJson.ok((Object)message);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u5546\u54c1\u540d\u79f0", required=true)})
    @GetMapping(value={"/matchGoodsByName"})
    @ApiOperation(value="11-54-10 \u6a21\u7cca\u5339\u914d\u5546\u54c1\u901a\u8fc7\u5546\u54c1\u540d\u79f0(\u8fd4\u56de\u6240\u6709\u5546\u54c1\u5305\u542b\u5df2\u4e0b\u67b6)\u3010\u593a\u5b9d\u6dfb\u52a0\u5956\u54c1\u7528\u3011")
    public ResponseJson<List<GoodLotteryManageDTO>> matchGoodsByName(@Param(value="name") String name) {
        List goodsList = this.goodsManageService.matchGoodsByName(name);
        return ResponseJson.ok((Object)goodsList);
    }

    @ApiOperation(value="11-54-11 \u83b7\u53d6\u5546\u6237\u6240\u5c5e\u6240\u6709\u4e0a\u67b6\u5546\u54c1\u4fe1\u606f", nickname="\u803f\u6768\u6768")
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true), @ApiImplicitParam(name="type", value="\u5546\u54c1\u7c7b\u578b\uff0c\u975e\u5fc5\u586b\uff0c\u4e0d\u4f20\u5219\u8fd4\u56de\u666e\u901a\u5546\u54c1\uff0c0\uff1a\u666e\u901a\u5546\u54c1\uff0c 1\uff1a5\u6298\u4f1a\u5458\u65e5\u5546\u54c1\uff08\u8be6\u60c5\u9875\u9762\u5c55\u793a\u4e0d\u540c\uff09\uff0c 2\uff1a\u4f18\u60e0\u56e2\u8d2d\u5546\u54c1")})
    @GetMapping(value={"allGoods"})
    public ResponseJson<List<MerchantAllGoodsDTO>> allGoods(@RequestParam(value="merchantId") Long merchantId, @RequestParam(value="type", required=false) Integer type) {
        List merchantAllGoodsDTOList = this.goodsManageService.allGoods(merchantId, type);
        return ResponseJson.ok((Object)merchantAllGoodsDTOList);
    }
}

