/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.param.MerchantOpenVipParam;
import com.bxm.localnews.merchant.service.InterestsService;
import com.bxm.localnews.merchants.dto.InterestsInfoDTO;
import com.bxm.localnews.merchants.param.InterestsInfoParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/merchant/interests"})
@Api(tags={"11-51 \u6743\u76ca\u7ba1\u7406"})
public class InterestsController {
    private InterestsService interestsService;

    @Autowired
    public InterestsController(InterestsService interestsService) {
        this.interestsService = interestsService;
    }

    @ApiOperation(value="11-51-01 \u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"getList"})
    public ResponseJson<PageWarper<InterestsInfoDTO>> getPageList(InterestsInfoParam interestsInfoParam) {
        return ResponseJson.ok((Object)this.interestsService.getPageList(interestsInfoParam));
    }

    @ApiOperation(value="11-51-02 \u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6\u4fe1\u606f")
    @ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7")
    @GetMapping(value={"getByPhone"})
    public ResponseJson<InterestsInfoDTO> getByPhone(String phone) {
        return ResponseJson.ok((Object)this.interestsService.getByPhone(phone));
    }

    @ApiOperation(value="11-51-03 \u5f00\u901a\u4f1a\u5458")
    @PostMapping(value={"openVip"})
    public ResponseJson<Boolean> openVip(@RequestBody MerchantOpenVipParam merchantOpenVipParam) {
        if (Objects.equals(merchantOpenVipParam.getInterestsType(), 2)) {
            return ResponseJson.build((Message)Message.build((boolean)false).setMessage("\u6682\u672a\u5f00\u901a\u6b64\u529f\u80fd"));
        }
        return ResponseJson.ok((Object)this.interestsService.openVip(merchantOpenVipParam, 0));
    }

    @ApiOperation(value="11-51-04 \u4fee\u6539\u5907\u6ce8")
    @PostMapping(value={"updateRemark"})
    public ResponseJson<Boolean> updateRemark(@RequestBody MerchantOpenVipParam merchantOpenVipParam) {
        return ResponseJson.ok((Object)this.interestsService.updateRemark(merchantOpenVipParam));
    }
}

