/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.manage.controller;

import com.bxm.localnews.merchant.coupon.service.CouponInfoService;
import com.bxm.localnews.merchant.dto.coupon.ManageCouponDetailDTO;
import com.bxm.localnews.merchant.dto.coupon.ManageCouponItemDTO;
import com.bxm.localnews.merchant.dto.coupon.MerchantCouponUsableDTO;
import com.bxm.localnews.merchant.entity.Tuple;
import com.bxm.localnews.merchant.param.coupon.ManageCouponCreateParam;
import com.bxm.localnews.merchant.param.coupon.ManageCouponQueryParam;
import com.bxm.localnews.merchant.param.coupon.ManageCouponStatusParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"11-55 \u8fd0\u8425\u540e\u53f0\u4f18\u60e0\u5238\u7ba1\u7406"})
@RestController
@RequestMapping(value={"manage/merchant/coupon"})
public class MerchantCouponManageController {
    private final CouponInfoService couponInfoService;

    @Autowired
    public MerchantCouponManageController(CouponInfoService couponInfoService) {
        this.couponInfoService = couponInfoService;
    }

    @ApiOperation(value="11-55-01 \u5206\u9875\u67e5\u8be2\u4f18\u60e0\u5238")
    @GetMapping(value={"query"})
    public ResponseJson<PageWarper<ManageCouponItemDTO>> query(ManageCouponQueryParam param) {
        return ResponseJson.ok((Object)this.couponInfoService.queryByPage(param));
    }

    @ApiOperation(value="11-55-02 \u83b7\u53d6\u67e5\u8be2\u6761\u4ef6\u4e2d\u7684\u72b6\u6001\u7c7b\u578b")
    @GetMapping(value={"status"})
    public ResponseJson<List<Tuple>> getStatusList() {
        return ResponseJson.ok((Object)this.couponInfoService.getCouponStatusList());
    }

    @ApiOperation(value="11-55-03 \u66f4\u65b0\u4f18\u60e0\u5238\u7684\u72b6\u6001")
    @PostMapping(value={"change"})
    public ResponseJson changeStatus(@RequestBody ManageCouponStatusParam param) {
        return ResponseJson.build((Message)this.couponInfoService.changeStatusWithManage(param));
    }

    @ApiOperation(value="11-55-04 \u521b\u5efa\u6216\u7f16\u8f91\u4f18\u60e0\u5238")
    @PostMapping(value={"create"})
    public ResponseJson create(@RequestBody ManageCouponCreateParam param) {
        return ResponseJson.build((Message)this.couponInfoService.saveCouponWithManage(param));
    }

    @ApiOperation(value="11-55-05 \u83b7\u53d6\u4f18\u60e0\u5238\u8be6\u60c5")
    @ApiImplicitParam(name="couponId", value="\u4f18\u60e0\u5238ID")
    @GetMapping(value={"detail"})
    public ResponseJson<ManageCouponDetailDTO> getStatusList(Long couponId) {
        return ResponseJson.ok((Object)this.couponInfoService.getCouponDetailWithManage(couponId));
    }

    @ApiOperation(value="11-55-06 \u83b7\u53d6\u5546\u6237\u6240\u5c5e\u6240\u6709\u53ef\u7528\u4f18\u60e0\u5238\u4fe1\u606f")
    @ApiImplicitParam(name="merchantId", value="\u5546\u6237id")
    @GetMapping(value={"queryUsableCoupon"})
    public ResponseJson<List<MerchantCouponUsableDTO>> getCouponListByMerchantId(@RequestParam(value="merchantId") Long merchantId) {
        return ResponseJson.ok((Object)this.couponInfoService.getCouponListByMerchantId(merchantId));
    }
}

