/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.security.enums;

import com.bxm.localnews.merchant.security.enums.MerchantAuthCodeEnum;
import java.util.Objects;

public enum MerchantRoleEnum {
    MEMBER_ROLE_BOSS(0, "\u8001\u677f", MerchantAuthCodeEnum.values()),
    MEMBER_ROLE_EMPLOYEE(1, "\u5458\u5de5", MerchantAuthCodeEnum.values());

    private Integer roleCode;
    private String roleName;
    private MerchantAuthCodeEnum[] authCodes;

    public Integer getRoleCode() {
        return this.roleCode;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public MerchantAuthCodeEnum[] getAuthCodes() {
        return this.authCodes;
    }

    private MerchantRoleEnum(Integer roleCode, String roleName, MerchantAuthCodeEnum ... authCodes) {
        this.roleCode = roleCode;
        this.roleName = roleName;
        this.authCodes = authCodes;
        if (this.authCodes == null) {
            this.authCodes = new MerchantAuthCodeEnum[0];
        }
    }

    public static MerchantRoleEnum getRole(Integer roleCode) {
        for (MerchantRoleEnum value : MerchantRoleEnum.values()) {
            if (!Objects.equals(value.getRoleCode(), roleCode)) continue;
            return value;
        }
        return null;
    }
}

