package com.bxm.localnews.merchant.security.facade.service;

import com.bxm.localnews.merchant.security.facade.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.security.facade.dto.RelationshipDto;
import com.bxm.localnews.merchant.security.facade.param.CreateParam;
import com.bxm.localnews.merchant.security.facade.param.MemberTeamParam;
import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @author liujia
 * @date 12/24/20 2:37 PM
 **/
public interface MerchantMemberFacadeService {
    /**
     * 商家团队成员信息
     *
     * @param param 查询上行参数
     * @return 商家团队成员信息分页列表数据
     */
    PageWarper<MechantTeamInfosDTO> getMemberInfo(MemberTeamParam param);

    /**
     * 获取有效的商家店铺成员信息
     *
     * @return 店铺成员信息
     */
    List<MerchantMemberVo> getAllEffectiveMember();

    /**
     * 获取商家的老板信息
     *
     * @param merchantId 商家ID
     * @return 老板信息
     */
    MerchantMemberVo getBoosByMerchantId(Long merchantId);

    /**
     * 获取绑定关系相关信息
     *
     * @param
     * @return
     */
    RelationshipDto getRelationship(Long userId);

    /**
     * 获取成员身份信息
     *
     * @param
     * @return
     */
    MerchantMemberVo getMemberInfo(Long userId);

    /**
     * 获取商家的成员数量
     *
     * @param merchantId 商家ID
     * @return 商家成员数量
     */
    int memberNum(Long merchantId);

    /**
     * 老板绑定商户
     *
     * @param merchantId 商户id
     * @param userId     用户id
     */
    void bossCreate(Long merchantId, Long userId);

    /**
     * 更换商户的老板
     *
     * @param memberVo   商户营销团队成员信息
     * @param merchantId 商户id
     * @param userId     用户id
     */
    void updateBossBind(MerchantMemberVo memberVo, Long merchantId, Long userId);

    /**
     * 员工绑定商户
     *
     * @param createParam
     * @return
     */
    Message create(CreateParam createParam);

    /**
     * 更新成员信息的冗余信息
     *
     * @param userId   用户ID
     * @param headImg  用户头像
     * @param nickName 用户昵称
     */
    void updateHeadImgAndNickName(Long userId, String headImg, String nickName);
}
