package com.bxm.localnews.merchant.security.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * @author liujia
 * @date 12/23/20 2:46 PM
 **/
@ApiModel(description = "商户成员的角色信息，一个成员只有一个角色")
@Data
@Builder
public class MerchantMemberRoleDTO {

    @Tolerate
    public MerchantMemberRoleDTO() {
    }

    @ApiModelProperty("角色编码")
    private Integer roleCode;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("角色拥有的权限编码，详见：http://wiki.bianxianmao.cn/pages/viewpage.action?pageId=25991478")
    private List<String> authCodes;
}
