/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.config;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.config.ActivityGoodsProperties;
import com.bxm.localnews.merchant.config.CustomScheduledThreadPoolExecutor;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;

@Configuration
public class ActivityGoodsCountAsyncPoolConfig
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ActivityGoodsCountAsyncPoolConfig.class);
    @Resource
    private ActivityGoodsProperties activityGoodsProperties;

    @Bean(name={"activityGoodsCountAsyncExecutor"})
    public Executor getAsyncExecutor() {
        return new CustomScheduledThreadPoolExecutor(10, this.activityGoodsProperties.getGoodsCountResetDelayTime());
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new AsyncExceptionHandler();
    }

    public static class AsyncExceptionHandler
    implements AsyncUncaughtExceptionHandler {
        public void handleUncaughtException(Throwable throwable, Method method, Object ... objects) {
            log.info("AsyncError: {}, Method: {}, Param: {}", new Object[]{throwable.getMessage(), method.getName(), JSON.toJSONString((Object)objects)});
            throwable.printStackTrace();
        }
    }
}

