/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.config;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(CustomScheduledThreadPoolExecutor.class);
    private int delayTime;

    public CustomScheduledThreadPoolExecutor(int corePoolSize, int delayTime) {
        super(corePoolSize);
        this.delayTime = delayTime;
    }

    public CustomScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public CustomScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public CustomScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public CustomScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        log.info("\u9012\u4ea4\u4efb\u52a1\uff0c\u8f6c\u4e3a\u5ef6\u8fdf\u4efb\u52a1");
        super.schedule(command, (long)this.delayTime, TimeUnit.SECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        log.info("\u9012\u4ea4\u5ef6\u8fdf\u4efb\u52a1");
        return super.schedule(command, delay, unit);
    }

    @Override
    public Future<?> submit(Runnable task) {
        log.info("\u9012\u4ea4\u4efb\u52a1\uff0c\u8f6c\u4e3a\u5ef6\u8fdf\u4efb\u52a1");
        return super.schedule(task, (long)this.delayTime, TimeUnit.SECONDS);
    }

    public Future<?> submit(Callable callable) {
        log.info("\u9012\u4ea4\u4efb\u52a1\uff0c\u8f6c\u4e3a\u5ef6\u8fdf\u4efb\u52a1");
        return super.schedule(callable, (long)this.delayTime, TimeUnit.SECONDS);
    }
}

