/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.cache;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class MemberDayGoodsCacheManage {
    private static final Logger log = LoggerFactory.getLogger(MemberDayGoodsCacheManage.class);
    private final MerchantInfoFacadeService merchantInfoDbService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;

    @Async(value="activityGoodsCountAsyncExecutor")
    public void resetCountActivityCount(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantId);
        String merchantAreaCode = merchantInfo.getAreaCode();
        int memberDayGoodsCount = this.merchantGoodsCategoryRelationMapper.countMemberDayGoodsCount(merchantAreaCode, merchantInfo.getCategoryId());
        int discountGroupGoodsCount = this.merchantGoodsCategoryRelationMapper.countDiscountGroupGoodsCount(merchantAreaCode, merchantInfo.getCategoryId());
        int activityGoodsCount = memberDayGoodsCount + discountGroupGoodsCount;
        log.info("\u91cd\u65b0\u7edf\u8ba1{}\u5730\u533a\u7f16\u7801\uff0c{}\u884c\u4e1a\u7684\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f, \u6d3b\u52a8\u6570\u91cf\u4e3a\uff1a{}", new Object[]{merchantAreaCode, merchantInfo.getCategoryId(), activityGoodsCount});
        this.redisHashMapAdapter.put(this.getIndustryMemberGoodsCountKey(merchantAreaCode), merchantInfo.getCategoryId().toString(), (Object)activityGoodsCount);
    }

    public Integer getMemberGoodsCount(String areaCode, Long industryId) {
        return (Integer)this.redisHashMapAdapter.get(this.getIndustryMemberGoodsCountKey(areaCode), industryId.toString(), Integer.class);
    }

    private KeyGenerator getIndustryMemberGoodsCountKey(String areaCode) {
        return RedisConfig.INDUSTRY_MEMBER_GOODS_COUNT.copy().appendKey((Object)areaCode);
    }

    public MemberDayGoodsCacheManage(MerchantInfoFacadeService merchantInfoDbService, RedisHashMapAdapter redisHashMapAdapter, MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper) {
        this.merchantInfoDbService = merchantInfoDbService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
    }
}

