/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.cache;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class MerchantGoodsCache {
    private RedisHashMapAdapter redisHashMapAdapter;
    private MerchantGoodsMapper merchantGoodsMapper;

    public MerchantGoodsVo getGoodsInfo(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = (MerchantGoodsVo)this.redisHashMapAdapter.get(this.buildKey(), goodsId + "", MerchantGoodsVo.class);
        if (Objects.isNull(merchantGoodsVo)) {
            return this.reload(goodsId);
        }
        return merchantGoodsVo;
    }

    public void refreshGoodsCache(Long goodsId) {
        this.reload(goodsId);
    }

    private MerchantGoodsVo reload(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(goodsId);
        if (Objects.isNull(merchantGoodsVo)) {
            return null;
        }
        this.redisHashMapAdapter.put(this.buildKey(), merchantGoodsVo.getId() + "", (Object)merchantGoodsVo);
        return merchantGoodsVo;
    }

    private KeyGenerator buildKey() {
        return RedisConfig.MERCHANT_GOODS_KEY.copy();
    }

    public MerchantGoodsCache(RedisHashMapAdapter redisHashMapAdapter, MerchantGoodsMapper merchantGoodsMapper) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.merchantGoodsMapper = merchantGoodsMapper;
    }
}

