/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsViewMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.goods.BarrageDTO;
import com.bxm.localnews.merchant.dto.goods.BarrageTopDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.merchant.dto.goods.UserRecordDTO;
import com.bxm.localnews.merchant.entity.MerchantGoodsViewEntity;
import com.bxm.localnews.merchant.events.GoodsOrderPaymentEvent;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.service.count.MerchantMemberCounterService;
import com.bxm.localnews.merchant.service.goods.GoodsBarrageService;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class GoodsBarrageServiceImpl
implements GoodsBarrageService {
    private static final Logger log = LoggerFactory.getLogger(GoodsBarrageServiceImpl.class);
    private final UserIntegrationService userIntegrationService;
    private final MerchantGoodsViewMapper merchantGoodsViewMapper;
    private final MerchantMemberCounterService merchantMemberCounterService;
    private final MerchantGoodsMapper merchantGoodsMapper;
    private GoodsService goodsService;
    private final SequenceCreater sequenceCreater;
    private final HyperLogLogAdapter hyperLogLogAdapter;
    private final RedisSetAdapter redisSetAdapter;
    private LoadingCache<String, List<UserInfoDTO>> localCache;
    private static final String TOP = "top";
    private static final String JOIN = "join";
    private Long fetchNum = 30L;
    private int keepCacheNum = 50;
    private int batchRemoveNum = 100;
    private String[] messageArray = new String[]{"\u521a\u521a\u67e5\u770b\u4e86\u5546\u54c1", "\u521a\u521a\u8d2d\u4e70\u4e86\u5546\u54c1"};

    @Autowired
    public GoodsBarrageServiceImpl(UserIntegrationService userIntegrationService, MerchantGoodsViewMapper merchantGoodsViewMapper, MerchantMemberCounterService merchantMemberCounterService, MerchantGoodsMapper merchantGoodsMapper, SequenceCreater sequenceCreater, HyperLogLogAdapter hyperLogLogAdapter, RedisSetAdapter redisSetAdapter) {
        this.userIntegrationService = userIntegrationService;
        this.merchantGoodsViewMapper = merchantGoodsViewMapper;
        this.merchantMemberCounterService = merchantMemberCounterService;
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.sequenceCreater = sequenceCreater;
        this.hyperLogLogAdapter = hyperLogLogAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.initCache();
    }

    @Override
    public BarrageDTO getBarrage(Long goodsId) {
        List viewRecords = this.redisSetAdapter.pop(this.buildViewSetKey(goodsId), this.fetchNum, UserRecordDTO.class);
        return BarrageDTO.builder().barrageTopList(this.buildBarrageTop(viewRecords)).headImgList(this.getJoinUser(viewRecords)).number(Integer.valueOf(Math.toIntExact(this.getJoinNum(goodsId)))).build();
    }

    private List<BarrageTopDTO> buildBarrageTop(List<UserRecordDTO> viewRecords) {
        ArrayList topMessages = Lists.newArrayList();
        List orderRecords = this.redisSetAdapter.pop(RedisConfig.GOODS_ORDER_PAYMENT_SET, Long.valueOf(this.fetchNum / 2L), UserRecordDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)orderRecords)) {
            topMessages.addAll(orderRecords.stream().map(user -> BarrageTopDTO.builder().headImg(user.getHeadImg()).message(this.dealNickName(user.getNickName()) + this.messageArray[1]).build()).collect(Collectors.toList()));
        }
        if (viewRecords != null) {
            topMessages.addAll(viewRecords.stream().limit(this.fetchNum / 2L).map(user -> BarrageTopDTO.builder().headImg(user.getHeadImg()).message(this.dealNickName(user.getNickName()) + this.messageArray[0]).build()).collect(Collectors.toList()));
        }
        if ((long)topMessages.size() < this.fetchNum) {
            List topVirtualUsers = (List)this.localCache.getUnchecked((Object)TOP);
            topMessages.addAll(topVirtualUsers.stream().limit(this.fetchNum - (long)topMessages.size()).map(user -> BarrageTopDTO.builder().headImg(user.getHeadImg()).message(this.dealNickName(user.getNickname()) + this.messageArray[RandomUtils.nextInt((int)0, (int)2)]).build()).collect(Collectors.toList()));
        }
        Collections.shuffle(topMessages);
        return topMessages;
    }

    @Override
    @EventListener
    @Async
    public void addOrder(GoodsOrderPaymentEvent event) {
        log.info("\u63a5\u6536\u5230\u7528\u6237\u4e0b\u5355\u4e8b\u4ef6\uff1a{}", (Object)JSON.toJSONString((Object)event));
        UserRecordDTO userRecord = this.getUserRecord(event.getUserId());
        if (null != userRecord) {
            this.redisSetAdapter.add(RedisConfig.GOODS_ORDER_PAYMENT_SET, new Object[]{userRecord});
        }
    }

    private Long getJoinNum(Long goodsId) {
        Long viewCount = this.hyperLogLogAdapter.size(new KeyGenerator[]{this.buildLogKey(goodsId)});
        if (null == viewCount) {
            viewCount = 0L;
        }
        viewCount = viewCount + this.fetchNum;
        return viewCount;
    }

    private List<String> getJoinUser(List<UserRecordDTO> viewRecords) {
        List<String> joinHeadImgs = viewRecords.stream().map(UserRecordDTO::getHeadImg).collect(Collectors.toList());
        if ((long)joinHeadImgs.size() < this.fetchNum) {
            List joinUsers = (List)this.localCache.getUnchecked((Object)JOIN);
            joinHeadImgs.addAll(joinUsers.stream().limit(this.fetchNum - (long)joinHeadImgs.size()).map(UserInfoDTO::getHeadImg).collect(Collectors.toList()));
        }
        return joinHeadImgs;
    }

    private UserRecordDTO getUserRecord(Long userId) {
        UserInfoDTO cacheUser = this.userIntegrationService.getUserFromRedisDB(userId);
        if (cacheUser != null) {
            return UserRecordDTO.builder().headImg(cacheUser.getHeadImg()).nickName(cacheUser.getNickname()).userId(cacheUser.getId()).build();
        }
        log.warn("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65f6\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff0cID:{}", (Object)userId);
        return null;
    }

    @Override
    public void saveViewRecord(MerchantGoodsViewEntity entity) {
        UserRecordDTO recordUser;
        if (null == entity || entity.getGoodsId() == null) {
            log.error("\u5546\u54c1\u4fe1\u606f\u6d4f\u89c8\u8bb0\u5f55\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u6d4f\u89c8\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)entity));
        }
        if (entity.getId() == null) {
            entity.setId(this.sequenceCreater.nextLongId());
        }
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(new Date());
        }
        if (null != entity.getUserId() && StringUtils.isBlank((String)entity.getNickName())) {
            UserInfoDTO cacheUser = this.userIntegrationService.getUserFromRedisDB(entity.getUserId());
            entity.setNickName(cacheUser.getNickname());
            entity.setHeadImg(cacheUser.getHeadImg());
        }
        this.merchantGoodsViewMapper.insert(entity);
        KeyGenerator logKey = this.buildLogKey(entity.getGoodsId());
        KeyGenerator viewSetKey = this.buildViewSetKey(entity.getGoodsId());
        Long res = this.hyperLogLogAdapter.add(logKey, (Object[])new Long[]{entity.getUserId()});
        if (Objects.equals(res, 1L)) {
            if (log.isDebugEnabled()) {
                log.debug("\u589e\u52a0\u5546\u54c1\u7684\u6d4f\u89c8\u6570\u636e\uff0c\u5546\u54c1ID\uff1a{}", (Object)entity.getGoodsId());
            }
            GoodsInfoAndUserIdDTO goodsInfo = this.getGoodsService().getByGoodsId(entity.getGoodsId());
            this.merchantMemberCounterService.addClickCounter(entity.getUserId(), goodsInfo.getMerchantId(), String.valueOf(entity.getUserId()), 1);
        }
        int maxViewCacheNum = 100;
        if (this.redisSetAdapter.size(viewSetKey) < (long)maxViewCacheNum && (recordUser = this.getUserRecord(entity.getUserId())) != null) {
            this.redisSetAdapter.add(viewSetKey, new Object[]{recordUser});
        }
    }

    private GoodsService getGoodsService() {
        if (null == this.goodsService) {
            this.goodsService = (GoodsService)SpringContextHolder.getBean(GoodsService.class);
        }
        return this.goodsService;
    }

    @Override
    public void clearExtraViewRecord() {
        this.removeOrderCache();
        this.removeExtraGoodsCacheWithPage(0);
    }

    private void removeExtraGoodsCacheWithPage(int start) {
        int batchQueryNum = 500;
        List goodsIdList = this.merchantGoodsMapper.queryByPage(start, batchQueryNum);
        if (goodsIdList.size() == 0) {
            return;
        }
        goodsIdList.parallelStream().forEach(this::removeGoodsCache);
        if (goodsIdList.size() == batchQueryNum) {
            this.removeExtraGoodsCacheWithPage(start + batchQueryNum);
        }
    }

    private void removeGoodsCache(Long goodsId) {
        KeyGenerator viewSetKey = this.buildViewSetKey(goodsId);
        Long size = this.redisSetAdapter.size(viewSetKey);
        if (size > (long)this.keepCacheNum) {
            long removeNum = size - (long)this.keepCacheNum;
            if (removeNum > (long)this.batchRemoveNum) {
                removeNum = this.batchRemoveNum;
            }
            List removeRecords = this.redisSetAdapter.pop(viewSetKey, Long.valueOf(removeNum), UserRecordDTO.class);
            this.redisSetAdapter.remove(viewSetKey, new Object[]{removeRecords});
            this.removeGoodsCache(goodsId);
        }
    }

    private void removeOrderCache() {
        Long size = this.redisSetAdapter.size(RedisConfig.GOODS_ORDER_PAYMENT_SET);
        if (size > (long)this.keepCacheNum) {
            long removeNum = size - (long)this.keepCacheNum;
            if (removeNum > (long)this.batchRemoveNum) {
                removeNum = this.batchRemoveNum;
            }
            List removeRecords = this.redisSetAdapter.pop(RedisConfig.GOODS_ORDER_PAYMENT_SET, Long.valueOf(removeNum), UserRecordDTO.class);
            this.redisSetAdapter.remove(RedisConfig.GOODS_ORDER_PAYMENT_SET, new Object[]{removeRecords});
            this.removeOrderCache();
        }
    }

    private KeyGenerator buildLogKey(Long goodsId) {
        return RedisConfig.GOODS_VIEW_COUNTER.copy().appendKey((Object)goodsId);
    }

    private KeyGenerator buildViewSetKey(Long goodsId) {
        return RedisConfig.GOODS_VIEW_SET.copy().appendKey((Object)goodsId);
    }

    private String dealNickName(String nickName) {
        int nickNameLength = 5;
        if (StringUtils.length((String)nickName) > nickNameLength) {
            nickName = StringUtils.substring((String)nickName, (int)0, (int)nickNameLength) + "...";
        }
        return nickName;
    }

    private void initCache() {
        this.localCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<UserInfoDTO>>(){

            public List<UserInfoDTO> load(String key) {
                return GoodsBarrageServiceImpl.this.userIntegrationService.getVirtualUserList(Integer.valueOf(Math.toIntExact(GoodsBarrageServiceImpl.this.fetchNum)));
            }
        });
    }
}

