/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchant.common.enums.GoodsCategoryTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantGoodsInfoProperties;
import com.bxm.localnews.merchant.constant.DistributedKey;
import com.bxm.localnews.merchant.domain.MerchantGoodsAuthRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsSampleMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.dto.goods.GoodLotteryManageDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsSampleListDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantAllGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.QueryGoodsManageDTO;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsCategoryRelationEntity;
import com.bxm.localnews.merchant.param.GoodsIdManageParamFail;
import com.bxm.localnews.merchant.param.goods.GoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.GoodsIdManageParam;
import com.bxm.localnews.merchant.param.goods.GoodsPosterParam;
import com.bxm.localnews.merchant.param.goods.GoodsSampleListParam;
import com.bxm.localnews.merchant.param.goods.GoodsUpdateManageParam;
import com.bxm.localnews.merchant.param.goods.ManageGoodsListParam;
import com.bxm.localnews.merchant.param.goods.updateGoodsSampleParam;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.service.goods.GoodsManageService;
import com.bxm.localnews.merchant.service.goods.cache.MemberDayGoodsCacheManage;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.GoodAddStrategyManage;
import com.bxm.localnews.merchant.vo.MerchantGoodsAuthRecordVo;
import com.bxm.localnews.merchant.vo.MerchantGoodsRecordVO;
import com.bxm.localnews.merchant.vo.goods.GoodsListVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsSampleVO;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsManageServiceImpl
implements GoodsManageService {
    private static final Logger log = LogManager.getLogger(GoodsManageServiceImpl.class);
    private final MerchantGoodsMapper merchantGoodsMapper;
    private final MerchantGoodsRecordMapper merchantGoodsRecordMapper;
    private final MerchantGoodsSampleMapper merchantGoodsSampleMapper;
    private final MerchantGoodsAuthRecordMapper merchantGoodsAuthRecordMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final PushIntegrationService pushIntegrationService;
    private final MerchantInfoFacadeService merchantInfoDbService;
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final SequenceCreater sequenceCreater;
    private final GoodAddStrategyManage goodAddStrategyManage;
    private final MemberDayGoodsCacheManage memberDayGoodsCacheManage;
    private final MerchantGoodsInfoProperties merchantGoodsInfoProperties;
    private final ScheduledThreadPoolExecutor executor;
    private final DistributedLock lock;

    @Override
    public PageWarper<GoodsSampleListDTO> getGoodsSampleList(GoodsSampleListParam goodsSampleListParam) {
        ArrayList goodsSampleListDTOList = new ArrayList();
        List merchantGoodsSampleVos = this.merchantGoodsSampleMapper.queryGoodsSampleListByPage(goodsSampleListParam);
        if (!CollectionUtils.isEmpty((Collection)merchantGoodsSampleVos)) {
            merchantGoodsSampleVos.forEach(merchantGoodsSampleVO -> {
                if (merchantGoodsSampleVO != null) {
                    GoodsSampleListDTO goodsSampleListDTO = new GoodsSampleListDTO();
                    goodsSampleListDTO.setCategoryId(merchantGoodsSampleVO.getCategoryId());
                    goodsSampleListDTO.setCatName(merchantGoodsSampleVO.getCatName());
                    goodsSampleListDTO.setGoodsId(merchantGoodsSampleVO.getSampleId());
                    goodsSampleListDTOList.add(goodsSampleListDTO);
                }
            });
            return new PageWarper(goodsSampleListDTOList);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    @Override
    public Message updateGoodsSample(updateGoodsSampleParam updateGoodsSampleParam2) {
        List merchantGoodsSampleVOS = this.merchantGoodsSampleMapper.selectBySampleId(updateGoodsSampleParam2.getSampleId());
        if (Objects.nonNull(merchantGoodsSampleVOS) && merchantGoodsSampleVOS.size() > 0) {
            return Message.build((boolean)false, (String)"\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\u5546\u54c1");
        }
        MerchantGoodsSampleVO merchantGoodsSampleVO = new MerchantGoodsSampleVO();
        BeanUtils.copyProperties((Object)updateGoodsSampleParam2, (Object)merchantGoodsSampleVO);
        this.merchantGoodsSampleMapper.updateByPrimaryKeySelective(merchantGoodsSampleVO);
        return Message.build((boolean)true);
    }

    @Override
    public PageWarper<GoodsListVo> getMerchantList(ManageGoodsListParam manageGoodsListParam) {
        List goodsList = this.merchantGoodsMapper.getGoodsList(manageGoodsListParam);
        if (!CollectionUtils.isEmpty((Collection)goodsList)) {
            goodsList.forEach(goodsListVo -> {
                if (goodsListVo != null) {
                    goodsListVo.setDistributionAmount(goodsListVo.getPrice().multiply(BigDecimal.valueOf((double)goodsListVo.getCommissionRate().intValue() * 0.01)).setScale(2, 4));
                    goodsListVo.setSaleNum(Integer.valueOf(goodsListVo.getTotalNum() - goodsListVo.getNum()));
                    goodsListVo.setGoodsId(goodsListVo.getId());
                    goodsListVo.setHasDisCountGroup(Integer.valueOf(this.getHasDisCountGroup(goodsListVo.getId()) ? 1 : 0));
                }
            });
            return new PageWarper(goodsList);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    private boolean getHasDisCountGroup(long goodsId) {
        List goodsCategoryList = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(Long.valueOf(goodsId));
        if (CollectionUtils.isEmpty((Collection)goodsCategoryList)) {
            log.error("\u5546\u54c1\u5206\u7c7b\u5b58\u5728\u9519\u8bef\uff0c\u81f3\u5c11\u5c5e\u4e8e\u666e\u901a\u5546\u54c1\u5206\u7c7b\u5546\u54c1id\uff1a{}", (Object)goodsId);
        }
        Set goodsCategoryTypeList = goodsCategoryList.stream().map(MerchantGoodsCategoryRelationEntity::getType).collect(Collectors.toSet());
        return goodsCategoryTypeList.contains(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode());
    }

    private MerchantGoodsCategoryRelationEntity getGoodsDiscountCategoryInfo(long goodsId) {
        List goodsCategoryList = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(Long.valueOf(goodsId));
        if (CollectionUtils.isEmpty((Collection)goodsCategoryList)) {
            log.error("\u5546\u54c1\u5206\u7c7b\u5b58\u5728\u9519\u8bef\uff0c\u81f3\u5c11\u5c5e\u4e8e\u666e\u901a\u5546\u54c1\u5206\u7c7b\u5546\u54c1id\uff1a{}", (Object)goodsId);
        }
        for (MerchantGoodsCategoryRelationEntity goodCategory : goodsCategoryList) {
            if (GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode() != goodCategory.getType()) continue;
            return goodCategory;
        }
        return null;
    }

    @Override
    public Message auditSuccess(GoodsIdManageParam goodsIdManageParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsIdManageParam.getGoodsId());
        if (Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType()) && Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_DOWN.getType())) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5df2\u4e0b\u67b6\u7684\u5546\u54c1\u4e0d\u80fd\u64cd\u4f5c");
        }
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        if (Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType())) {
            return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u5ba1\u6838\u6210\u529f");
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORMERCHANTMES.getDesc());
        }
        MerchantGoodsVo vo = new MerchantGoodsVo();
        vo.setId(merchantGoodsVo.getId());
        vo.setVersion(merchantGoodsVo.getVersion());
        vo.setQualificationStatus(Integer.valueOf(2));
        vo.setShelfType(Integer.valueOf(1));
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(vo) == 0) {
            if (log.isDebugEnabled()) {
                log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)vo);
            }
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
        }
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        this.pushIntegrationService.pushGoodsMsg(merchantGoodsVo, merchantInfo, MerchantGoodsEnum.AUDIT_GOODS_SUCCESS, null);
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{merchantGoodsVo.getId() + ""});
        this.auditSuccessLog(goodsIdManageParam);
        return Message.build((boolean)true);
    }

    @Override
    public Message auditFail(GoodsIdManageParamFail goodsIdManageParamFail) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsIdManageParamFail.getGoodsId());
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        if (Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType()) && Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_DOWN.getType())) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5df2\u4e0b\u67b6\u7684\u5546\u54c1\u4e0d\u80fd\u64cd\u4f5c");
        }
        if (Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_FAIL.getType())) {
            return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u5ba1\u6838\u5931\u8d25");
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORMERCHANTMES.getDesc());
        }
        MerchantGoodsVo vo = new MerchantGoodsVo();
        vo.setId(goodsIdManageParamFail.getGoodsId());
        vo.setVersion(merchantGoodsVo.getVersion());
        vo.setQualificationStatus(Integer.valueOf(3));
        vo.setShelfType(Integer.valueOf(0));
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(vo) == 0) {
            if (log.isDebugEnabled()) {
                log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)vo);
            }
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
        }
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsIdManageParamFail.getGoodsId() + ""});
        this.pushIntegrationService.pushGoodsMsg(merchantGoodsVo, merchantInfo, MerchantGoodsEnum.AUDIT_GOODS_FAIL, goodsIdManageParamFail.getRemark());
        this.auditFailLog(goodsIdManageParamFail);
        return Message.build((boolean)true);
    }

    @Override
    public Message queryGoods(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        QueryGoodsManageDTO queryGoodsManageDTO = new QueryGoodsManageDTO();
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)queryGoodsManageDTO);
        MerchantGoodsAuthRecordVo merchantGoodsAuthRecordVo = this.merchantGoodsAuthRecordMapper.selectByPrimaryKey(merchantGoodsVo.getId());
        queryGoodsManageDTO.setRemark(Objects.nonNull(merchantGoodsAuthRecordVo) ? merchantGoodsAuthRecordVo.getRemark() : null);
        queryGoodsManageDTO.setGoodsId(merchantGoodsVo.getId());
        MerchantGoodsCategoryRelationEntity goodsDiscountCategoryInfo = this.getGoodsDiscountCategoryInfo(merchantGoodsVo.getId());
        if (Objects.isNull(goodsDiscountCategoryInfo)) {
            queryGoodsManageDTO.setHasDisCountGroup(Integer.valueOf(0));
        } else {
            queryGoodsManageDTO.setHasDisCountGroup(Integer.valueOf(1));
            queryGoodsManageDTO.setOrder(goodsDiscountCategoryInfo.getOrder());
        }
        return Message.build((boolean)true).addParam("queryGoodsManageDTO", (Object)queryGoodsManageDTO);
    }

    @Override
    public Message create(GoodsCreateParam goodsCreateParam) {
        if (goodsCreateParam.getName().length() > this.merchantGoodsInfoProperties.getGoodsNameLength()) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u540d\u79f0\u8bf7\u63a7\u5236\u57281-" + this.merchantGoodsInfoProperties.getGoodsNameLength() + "\u5b57\u7b26\u4e4b\u95f4");
        }
        GoodsAddContext context = GoodsAddContext.builder().categoryType(GoodsCategoryTypeEnum.ORDINARY.getCode()).goodsCreateParam(goodsCreateParam).build();
        this.goodAddStrategyManage.execute(context);
        return Message.build((boolean)true);
    }

    private void addDiscountGroupInfo(Integer order, Long goodsId) {
        MerchantGoodsCategoryRelationEntity discountGroupCategoryInfo = new MerchantGoodsCategoryRelationEntity();
        discountGroupCategoryInfo.setId(this.sequenceCreater.nextLongId());
        discountGroupCategoryInfo.setGoodsId(goodsId);
        discountGroupCategoryInfo.setOrder(order);
        discountGroupCategoryInfo.setType(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode());
        this.merchantGoodsCategoryRelationMapper.insertSelective(discountGroupCategoryInfo);
    }

    @Override
    public Message update(GoodsUpdateManageParam goodsUpdateManageParam) {
        long repeatCommitTimeLimit;
        String requestId;
        if (goodsUpdateManageParam.getName().length() > this.merchantGoodsInfoProperties.getGoodsNameLength()) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u540d\u79f0\u8bf7\u63a7\u5236\u57281-" + this.merchantGoodsInfoProperties.getGoodsNameLength() + "\u5b57\u7b26\u4e4b\u95f4");
        }
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsUpdateManageParam.getGoodsId());
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        if (Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType()) && Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_DOWN.getType())) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5df2\u4e0b\u67b6\u7684\u5546\u54c1\u4e0d\u80fd\u64cd\u4f5c");
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (merchantInfo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORMERCHANTMES.getDesc());
        }
        String resourceKey = this.genUpdateGoodsLockKey(goodsUpdateManageParam.getGoodsId());
        if (this.lock.lock(resourceKey, requestId = this.sequenceCreater.nextStringId(), repeatCommitTimeLimit = 2L, TimeUnit.SECONDS)) {
            MerchantGoodsVo goodsVo = new MerchantGoodsVo();
            BeanUtils.copyProperties((Object)goodsUpdateManageParam, (Object)goodsVo);
            goodsVo.setId(goodsUpdateManageParam.getGoodsId());
            goodsVo.setTotalNum(this.countTotalNum(goodsUpdateManageParam.getNum(), merchantGoodsVo));
            goodsVo.setVersion(Objects.nonNull(merchantGoodsVo.getVersion()) ? merchantGoodsVo.getVersion() : null);
            goodsVo.setModifyTime(new Date());
            if (!Objects.equals(goodsVo.getQualificationStatus(), merchantGoodsVo.getQualificationStatus())) {
                if (Objects.equals(goodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType())) {
                    goodsVo.setShelfType(Integer.valueOf(1));
                    this.pushIntegrationService.pushGoodsMsg(goodsVo, merchantInfo, MerchantGoodsEnum.AUDIT_GOODS_SUCCESS, null);
                }
                if (Objects.equals(goodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_FAIL.getType())) {
                    goodsVo.setShelfType(Integer.valueOf(0));
                    this.pushIntegrationService.pushGoodsMsg(goodsVo, merchantInfo, MerchantGoodsEnum.AUDIT_GOODS_SUCCESS, goodsUpdateManageParam.getRemark());
                }
                this.addAllLog(goodsVo, goodsUpdateManageParam);
            }
            if (this.merchantGoodsMapper.updateByPrimaryKeySelective(goodsVo) == 0) {
                if (log.isDebugEnabled()) {
                    log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)merchantGoodsVo);
                }
                return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
            }
            this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
            this.updateDiscountGroup(goodsUpdateManageParam);
            this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsVo.getId() + ""});
            this.addMerchantGoodsLog(goodsVo);
            this.lock.unlock(resourceKey, requestId);
        }
        return Message.build((boolean)true, (String)"\u4fee\u6539\u5546\u54c1\u6210\u529f");
    }

    private String genUpdateGoodsLockKey(Long goodsId) {
        return DistributedKey.UPDATE_GOODS_MANAGE.copy().appendKey((Object)goodsId).gen();
    }

    private void updateDiscountGroup(GoodsUpdateManageParam goodsUpdateManageParam) {
        Long goodsId = goodsUpdateManageParam.getGoodsId();
        if (Objects.isNull(goodsUpdateManageParam.getHasDisCountGroup())) {
            return;
        }
        boolean isDiscountGroupGoods = this.isDiscountGroupGoods(goodsUpdateManageParam.getGoodsId());
        if (goodsUpdateManageParam.getHasDisCountGroup().booleanValue()) {
            if (Boolean.FALSE.equals(isDiscountGroupGoods)) {
                this.addDiscountGroupInfo(goodsUpdateManageParam.getOrder(), goodsId);
            }
        } else if (isDiscountGroupGoods) {
            this.merchantGoodsCategoryRelationMapper.deleteByGoodsIdAndType(goodsId, GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode());
        }
    }

    private boolean isDiscountGroupGoods(long goodsId) {
        List goodsCategoryInfo = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(Long.valueOf(goodsId));
        Set goodsCategoryTypeSet = goodsCategoryInfo.stream().map(MerchantGoodsCategoryRelationEntity::getType).collect(Collectors.toSet());
        return goodsCategoryTypeSet.contains(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode());
    }

    public MerchantGoodsVo getGoodsInfo(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = (MerchantGoodsVo)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_GOODS_KEY, goodsId + "", MerchantGoodsVo.class);
        if (merchantGoodsVo == null) {
            merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(goodsId);
            if (merchantGoodsVo != null) {
                this.redisHashMapAdapter.put(RedisConfig.MEMBER_INFO_KEY, merchantGoodsVo.getId() + "", (Object)merchantGoodsVo);
                return merchantGoodsVo;
            }
            return null;
        }
        return merchantGoodsVo;
    }

    private Integer countTotalNum(Integer num, MerchantGoodsVo merchantGoodsVo) {
        Integer totalNum = merchantGoodsVo.getTotalNum();
        Integer oldNum = merchantGoodsVo.getNum();
        if (!Objects.equals(oldNum, num)) {
            if (num > oldNum) {
                int result = num - oldNum;
                totalNum = totalNum + result;
            } else {
                int result = oldNum - num;
                totalNum = totalNum - result;
            }
        }
        return totalNum;
    }

    private void auditSuccessLog(GoodsIdManageParam goodsIdManageParam) {
        MerchantGoodsAuthRecordVo merchantGoodsAuthRecordVo = new MerchantGoodsAuthRecordVo();
        merchantGoodsAuthRecordVo.setUserId(goodsIdManageParam.getUserId());
        merchantGoodsAuthRecordVo.setCreateTime(new Date());
        merchantGoodsAuthRecordVo.setGoodsId(goodsIdManageParam.getGoodsId());
        merchantGoodsAuthRecordVo.setQualificationStatus(Integer.valueOf(2));
        this.merchantGoodsAuthRecordMapper.insertSelective(merchantGoodsAuthRecordVo);
    }

    private void auditFailLog(GoodsIdManageParamFail goodsIdManageParamFail) {
        MerchantGoodsAuthRecordVo merchantGoodsAuthRecordVo = new MerchantGoodsAuthRecordVo();
        merchantGoodsAuthRecordVo.setUserId(goodsIdManageParamFail.getUserId());
        merchantGoodsAuthRecordVo.setCreateTime(new Date());
        merchantGoodsAuthRecordVo.setGoodsId(goodsIdManageParamFail.getGoodsId());
        merchantGoodsAuthRecordVo.setQualificationStatus(Integer.valueOf(3));
        merchantGoodsAuthRecordVo.setRemark(goodsIdManageParamFail.getRemark());
        this.merchantGoodsAuthRecordMapper.insertSelective(merchantGoodsAuthRecordVo);
    }

    private void addMerchantGoodsLog(MerchantGoodsVo merchantGoodsVo) {
        MerchantGoodsRecordVO merchantGoodsRecordVO = new MerchantGoodsRecordVO();
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantGoodsRecordVO);
        merchantGoodsRecordVO.setCreateTime(new Date());
        merchantGoodsRecordVO.setId(null);
        merchantGoodsRecordVO.setGoodsId(merchantGoodsVo.getId());
        this.merchantGoodsRecordMapper.insertSelective(merchantGoodsRecordVO);
    }

    private void addAllLog(MerchantGoodsVo merchantGoodsVo, GoodsUpdateManageParam goodsUpdateManageParam) {
        MerchantGoodsAuthRecordVo merchantGoodsAuthRecordVo = new MerchantGoodsAuthRecordVo();
        merchantGoodsAuthRecordVo.setUserId(goodsUpdateManageParam.getUserId());
        merchantGoodsAuthRecordVo.setCreateTime(new Date());
        merchantGoodsAuthRecordVo.setGoodsId(merchantGoodsVo.getId());
        merchantGoodsAuthRecordVo.setQualificationStatus(merchantGoodsVo.getQualificationStatus());
        merchantGoodsAuthRecordVo.setRemark(goodsUpdateManageParam.getRemark());
        this.merchantGoodsAuthRecordMapper.insertSelective(merchantGoodsAuthRecordVo);
        MerchantGoodsRecordVO merchantGoodsRecordVO = new MerchantGoodsRecordVO();
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantGoodsRecordVO);
        merchantGoodsRecordVO.setCreateTime(new Date());
        merchantGoodsRecordVO.setId(null);
        merchantGoodsRecordVO.setGoodsId(merchantGoodsVo.getId());
        this.merchantGoodsRecordMapper.insertSelective(merchantGoodsRecordVO);
    }

    @Override
    public Message saveOrUpdateGoodsPoster(GoodsPosterParam goodsCreateParam) {
        MerchantGoodsVo merchantGoodsInfo = this.getGoodsInfo(goodsCreateParam.getGoodsId());
        if (merchantGoodsInfo == null) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        merchantGoodsVo.setId(goodsCreateParam.getGoodsId());
        merchantGoodsVo.setPosterUrl(goodsCreateParam.getPosterUrl());
        merchantGoodsVo.setPosterName(goodsCreateParam.getPosterName());
        merchantGoodsVo.setPosterStatus(goodsCreateParam.getPosterStatus());
        merchantGoodsVo.setVersion(merchantGoodsInfo.getVersion());
        try {
            this.merchantGoodsMapper.updateByPrimaryKeySelective(merchantGoodsVo);
            this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{merchantGoodsInfo.getId() + ""});
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6d77\u62a5\u63a5\u53e3\u51fa\u9519\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)goodsCreateParam), (Object)e);
            return Message.build((boolean)false, (String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return Message.build((boolean)true);
    }

    @Override
    public List<GoodLotteryManageDTO> matchGoodsByName(String goodsName) {
        List goodLotteryManageDTOS = this.merchantGoodsMapper.matchGoodsByName(goodsName);
        return goodLotteryManageDTOS.stream().peek(t -> {
            if (Objects.equals(GoodsCategoryTypeEnum.MEMBER_DAY.getCode(), t.getGoodsType())) {
                t.setGoodsName(t.getGoodsName() + "\uff08\u4f1a\u5458\u65e5\u5546\u54c1\uff09");
            } else if (Objects.equals(GoodsCategoryTypeEnum.ORDINARY.getCode(), t.getGoodsType())) {
                t.setGoodsName(t.getGoodsName() + "\uff08\u56e2\u8d2d\u5546\u54c1\uff09");
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<MerchantAllGoodsDTO> allGoods(Long merchantId, Integer type) {
        int realType = GoodsCategoryTypeEnum.ORDINARY.getCode();
        if (Objects.nonNull(type)) {
            realType = type;
        }
        return this.merchantGoodsMapper.getAllGoods(merchantId, Integer.valueOf(realType));
    }

    public GoodsManageServiceImpl(MerchantGoodsMapper merchantGoodsMapper, MerchantGoodsRecordMapper merchantGoodsRecordMapper, MerchantGoodsSampleMapper merchantGoodsSampleMapper, MerchantGoodsAuthRecordMapper merchantGoodsAuthRecordMapper, RedisHashMapAdapter redisHashMapAdapter, PushIntegrationService pushIntegrationService, MerchantInfoFacadeService merchantInfoDbService, MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, SequenceCreater sequenceCreater, GoodAddStrategyManage goodAddStrategyManage, MemberDayGoodsCacheManage memberDayGoodsCacheManage, MerchantGoodsInfoProperties merchantGoodsInfoProperties, ScheduledThreadPoolExecutor executor, DistributedLock lock) {
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.merchantGoodsRecordMapper = merchantGoodsRecordMapper;
        this.merchantGoodsSampleMapper = merchantGoodsSampleMapper;
        this.merchantGoodsAuthRecordMapper = merchantGoodsAuthRecordMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.pushIntegrationService = pushIntegrationService;
        this.merchantInfoDbService = merchantInfoDbService;
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.sequenceCreater = sequenceCreater;
        this.goodAddStrategyManage = goodAddStrategyManage;
        this.memberDayGoodsCacheManage = memberDayGoodsCacheManage;
        this.merchantGoodsInfoProperties = merchantGoodsInfoProperties;
        this.executor = executor;
        this.lock = lock;
    }
}

