/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.constant.TalentLevelEnum;
import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.constant.MerchantGoodsEnum;
import com.bxm.localnews.merchant.common.enums.GoodsCategoryTypeEnum;
import com.bxm.localnews.merchant.common.enums.GoodsPosterStatusEnum;
import com.bxm.localnews.merchant.common.properties.MerchantGoodsInfoProperties;
import com.bxm.localnews.merchant.common.properties.MerchantGoodsRateProperties;
import com.bxm.localnews.merchant.domain.MerchantGoodsMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsRecordMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsSampleMapper;
import com.bxm.localnews.merchant.domain.MerchantGoodsUserFavoriteMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsMemberDayMapper;
import com.bxm.localnews.merchant.dto.LocationDTO;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.earnings.GoodsCommissionDTO;
import com.bxm.localnews.merchant.dto.goods.AllGoodsSumDTO;
import com.bxm.localnews.merchant.dto.goods.CalculateUserCommissionDTO;
import com.bxm.localnews.merchant.dto.goods.CollectionListDTO;
import com.bxm.localnews.merchant.dto.goods.ExampleGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsCategoryDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsCompare;
import com.bxm.localnews.merchant.dto.goods.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.merchant.dto.goods.GoodsListDTO;
import com.bxm.localnews.merchant.dto.goods.MerchantDto;
import com.bxm.localnews.merchant.dto.goods.QueryGoodsDTO;
import com.bxm.localnews.merchant.entity.MerchantGoodsViewEntity;
import com.bxm.localnews.merchant.entity.goods.MemberDayGoodsCategoryExtDataDTO;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsCategoryRelationEntity;
import com.bxm.localnews.merchant.entity.goods.MerchantGoodsMemberDayEntity;
import com.bxm.localnews.merchant.integration.LocationIntegrationService;
import com.bxm.localnews.merchant.integration.MarketIntegrationService;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.goods.AuditByUserParam;
import com.bxm.localnews.merchant.param.goods.CollectionListParam;
import com.bxm.localnews.merchant.param.goods.GoodsCreateParam;
import com.bxm.localnews.merchant.param.goods.GoodsIdParam;
import com.bxm.localnews.merchant.param.goods.GoodsLikeParam;
import com.bxm.localnews.merchant.param.goods.GoodsUpdateParam;
import com.bxm.localnews.merchant.param.goods.QueryAllGoodsParam;
import com.bxm.localnews.merchant.param.goods.QueryGoodsParam;
import com.bxm.localnews.merchant.param.goods.ShelfByUserParam;
import com.bxm.localnews.merchant.param.goods.SortParam;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.service.goods.GoodsBarrageService;
import com.bxm.localnews.merchant.service.goods.GoodsService;
import com.bxm.localnews.merchant.service.goods.cache.MemberDayGoodsCacheManage;
import com.bxm.localnews.merchant.service.goods.cache.MerchantGoodsCache;
import com.bxm.localnews.merchant.service.goods.context.GoodsAddContext;
import com.bxm.localnews.merchant.service.goods.strategy.GoodAddStrategyManage;
import com.bxm.localnews.merchant.utils.GoodsPriceRelatedUtils;
import com.bxm.localnews.merchant.vo.MerchantGoodsRecordVO;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsListVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsSampleVO;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsUserFavoriteVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodsVo;
import com.bxm.localnews.merchant.vo.goods.MerchantGoodstotalVo;
import com.bxm.localnews.merchants.dto.MerchantWorkGoodsDTO;
import com.bxm.localnews.merchants.facade.service.MerchantInfoFacadeService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.localnews.merchants.vo.MerchantInfoSimpleVO;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LogManager.getLogger(GoodsServiceImpl.class);
    private final MerchantGoodsMapper merchantGoodsMapper;
    private final UserIntegrationService userIntegrationService;
    private final MerchantGoodsRecordMapper merchantGoodsRecordMapper;
    private final MerchantGoodsSampleMapper merchantGoodsSampleMapper;
    private final MerchantGoodsUserFavoriteMapper merchantGoodsUserFavoriteMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final GoodAddStrategyManage goodAddStrategyManage;
    private final PushIntegrationService pushIntegrationService;
    private final LocationIntegrationService locationIntegrationService;
    private final GoodsBarrageService goodsBarrageService;
    private final MarketIntegrationService marketIntegrationService;
    private final MerchantInfoFacadeService merchantInfoDbService;
    private final MerchantGoodsCache merchantGoodsCache;
    private static final BigDecimal RATE_1 = new BigDecimal("0.01");
    private final MerchantGoodsRateProperties merchantGoodsRateProperties;
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final MerchantGoodsMemberDayMapper merchantGoodsMemberDayMapper;
    private final MemberDayGoodsCacheManage memberDayGoodsCacheManage;
    private final MerchantGoodsInfoProperties merchantGoodsInfoProperties;

    @Override
    public Message create(GoodsCreateParam goodsCreateParam) {
        if (goodsCreateParam.getName().length() > this.merchantGoodsInfoProperties.getGoodsNameLength()) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u540d\u79f0\u8bf7\u63a7\u5236\u57281-" + this.merchantGoodsInfoProperties.getGoodsNameLength() + "\u5b57\u7b26\u4e4b\u95f4");
        }
        GoodsAddContext context = GoodsAddContext.builder().categoryType(GoodsCategoryTypeEnum.ORDINARY.getCode()).goodsCreateParam(goodsCreateParam).build();
        return this.goodAddStrategyManage.execute(context);
    }

    private void record(QueryGoodsParam param) {
        if (!Objects.equals(param.getQueryType(), 2)) {
            if (param.getPlatform() == 0) {
                return;
            }
            MerchantGoodsViewEntity entity = new MerchantGoodsViewEntity();
            entity.setUserId(param.getUserId());
            entity.setSource(Byte.valueOf(param.getPlatform() + ""));
            entity.setGoodsId(param.getGoodsId());
            this.goodsBarrageService.saveViewRecord(entity);
        }
    }

    @Override
    public Message query(QueryGoodsParam param) {
        List merchantGoodsSampleVOS;
        boolean goodsStatus;
        long goodsId = param.getGoodsId();
        long userId = param.getUserId();
        int queryType = param.getQueryType();
        boolean isInfoQuery = queryType == 1 || queryType == 3;
        QueryGoodsDTO queryGoodsDTO = new QueryGoodsDTO();
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        if (Objects.isNull(merchantGoodsVo)) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (Objects.isNull(merchantInfo)) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            queryGoodsDTO.setPhone("");
            queryGoodsDTO.setBuyType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        queryGoodsDTO.setPhone(merchantInfo.getMobile());
        this.setBuyType(param, queryGoodsDTO);
        if (Objects.equals(merchantGoodsVo.getState(), 0)) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        this.record(param);
        boolean bl = goodsStatus = isInfoQuery && (!Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType()) || !Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_UP.getType()));
        if (goodsStatus) {
            queryGoodsDTO.setPageState(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
        }
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)queryGoodsDTO);
        queryGoodsDTO.setPageState(Integer.valueOf(1));
        queryGoodsDTO.setGoodsId(merchantGoodsVo.getId());
        queryGoodsDTO.setMerchantName(merchantInfo.getMerchantName());
        queryGoodsDTO.setMerchantId(merchantInfo.getId());
        queryGoodsDTO.setLatitude(merchantInfo.getLat());
        queryGoodsDTO.setLongitude(merchantInfo.getLng());
        queryGoodsDTO.setMerchantPic(StringUtils.isNotBlank((String)merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics().split(",")).get(0) : null);
        queryGoodsDTO.setGazePeopleNum(merchantGoodsVo.getGazePeopleNum());
        GoodsCategoryDTO goodsCategoryDTO = this.getGoodsCategoryId(goodsId);
        queryGoodsDTO.setGoodsCategory(goodsCategoryDTO.getCategoryType());
        queryGoodsDTO.setSubType(goodsCategoryDTO.getSubType());
        if (GoodsCategoryTypeEnum.MEMBER_DAY.getCode().equals(queryGoodsDTO.getGoodsCategory())) {
            queryGoodsDTO.setParticipateWeek(this.getParticipateWeekInfo(goodsId));
            Integer memberDayBaseSaleAmount = this.getMemberDayBaseSaleAmount(goodsId);
            queryGoodsDTO.setSaleNum(Integer.valueOf(merchantGoodsVo.getTotalNum() - merchantGoodsVo.getNum() + memberDayBaseSaleAmount));
        } else {
            queryGoodsDTO.setSaleNum(Integer.valueOf(merchantGoodsVo.getTotalNum() - merchantGoodsVo.getNum()));
        }
        queryGoodsDTO.setGoodsVersion(merchantGoodsVo.getVersion());
        if (Objects.equals(merchantGoodsVo.getPosterStatus(), GoodsPosterStatusEnum.OFF.getStatus())) {
            queryGoodsDTO.setPosterUrl("");
        }
        if (!CollectionUtils.isEmpty((Collection)(merchantGoodsSampleVOS = this.merchantGoodsSampleMapper.selectBySampleId(merchantGoodsVo.getId()))) && queryType == 1) {
            queryGoodsDTO.setSampleType(Integer.valueOf(1));
        } else {
            queryGoodsDTO.setSampleType(Integer.valueOf(0));
        }
        queryGoodsDTO.setImmediatelyPrice(this.getCommissionByUserId(userId, goodsId));
        BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(merchantGoodsVo.getPrice(), merchantGoodsVo.getVipDiscount());
        BigDecimal discount = GoodsPriceRelatedUtils.getDiscount(merchantGoodsVo.getPrice(), merchantGoodsVo.getVipDiscount(), merchantGoodsVo.getOriginalPrice(), vipPrice);
        BigDecimal reducedPrice = merchantGoodsVo.getPrice().subtract(vipPrice);
        if (reducedPrice.compareTo(BigDecimal.ZERO) < 0) {
            reducedPrice = BigDecimal.ZERO;
        }
        queryGoodsDTO.setAddress(this.getAddress(merchantInfo));
        queryGoodsDTO.setVipPrice(vipPrice);
        queryGoodsDTO.setDiscount(discount);
        queryGoodsDTO.setReducedPrice(reducedPrice);
        MerchantGoodsUserFavoriteVo merchantGoodsUserFavoriteVo = this.merchantGoodsUserFavoriteMapper.selectByUserAndGoods(Long.valueOf(userId), merchantGoodsVo.getId());
        if (Objects.nonNull(merchantGoodsUserFavoriteVo)) {
            queryGoodsDTO.setCollectionType(merchantGoodsUserFavoriteVo.getStatus());
        } else {
            queryGoodsDTO.setCollectionType(Integer.valueOf(0));
        }
        return Message.build((boolean)true).addParam("queryGoodsDTO", (Object)queryGoodsDTO);
    }

    private Integer getMemberDayBaseSaleAmount(long goodsId) {
        MerchantGoodsCategoryRelationEntity memberDayCategoryInfo = this.merchantGoodsCategoryRelationMapper.getByGoodsIdAndType(Long.valueOf(goodsId), GoodsCategoryTypeEnum.MEMBER_DAY.getCode());
        String extData = memberDayCategoryInfo.getExtData();
        MemberDayGoodsCategoryExtDataDTO extDataDTO = (MemberDayGoodsCategoryExtDataDTO)JSON.parseObject((String)extData, MemberDayGoodsCategoryExtDataDTO.class);
        Integer baseSaleCount = extDataDTO.getBaseSaleCount();
        return Objects.isNull(baseSaleCount) ? 0 : baseSaleCount;
    }

    private String getParticipateWeekInfo(long goodsId) {
        List memberDayWeekInfoList = this.merchantGoodsMemberDayMapper.getListByGoodsId(Long.valueOf(goodsId));
        if (CollectionUtils.isEmpty((Collection)memberDayWeekInfoList)) {
            log.error("\u4e94\u6298\u4f1a\u5458\u65e5\u65f6\u95f4\u4fe1\u606f\u9519\u8bef\uff0cgoodsId:{}", (Object)goodsId);
            return "";
        }
        Set<Integer> weekCountSet = memberDayWeekInfoList.stream().map(MerchantGoodsMemberDayEntity::getWeekCount).collect(Collectors.toSet());
        if (weekCountSet.size() == 7) {
            return "";
        }
        boolean hasSunday = weekCountSet.contains(0);
        weekCountSet.remove(0);
        StringBuilder participateWeekInfo = new StringBuilder("\u6bcf\u5468");
        weekCountSet.forEach(w -> participateWeekInfo.append(this.getWeekNameByCount((int)w)).append("\u3001"));
        if (hasSunday) {
            participateWeekInfo.append(this.getWeekNameByCount(0)).append("\u3001");
        }
        String participateWeekStr = participateWeekInfo.substring(0, participateWeekInfo.length() - 1);
        return participateWeekStr + "\u53ef\u7528";
    }

    private GoodsCategoryDTO getGoodsCategoryId(long goodsId) {
        List categoryInfoList = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(Long.valueOf(goodsId));
        Set goodsTypeSet = categoryInfoList.stream().map(MerchantGoodsCategoryRelationEntity::getType).collect(Collectors.toSet());
        if (goodsTypeSet.contains(GoodsCategoryTypeEnum.MEMBER_DAY.getCode())) {
            return GoodsCategoryDTO.builder().categoryType(GoodsCategoryTypeEnum.MEMBER_DAY.getCode()).subType(((MerchantGoodsCategoryRelationEntity)categoryInfoList.get(0)).getSubType()).build();
        }
        if (goodsTypeSet.contains(GoodsCategoryTypeEnum.ORDINARY.getCode())) {
            if (goodsTypeSet.contains(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode())) {
                return GoodsCategoryDTO.builder().categoryType(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode()).subType(this.getSubType(categoryInfoList, GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode())).build();
            }
            return GoodsCategoryDTO.builder().categoryType(GoodsCategoryTypeEnum.ORDINARY.getCode()).subType(this.getSubType(categoryInfoList, GoodsCategoryTypeEnum.ORDINARY.getCode())).build();
        }
        log.error("\u5546\u54c1\u7c7b\u578b\u6709\u8bef\uff0c\u5546\u54c1id\uff1a{}", (Object)goodsId);
        return GoodsCategoryDTO.builder().categoryType(GoodsCategoryTypeEnum.ORDINARY.getCode()).subType(Integer.valueOf(0)).build();
    }

    private Integer getSubType(List<MerchantGoodsCategoryRelationEntity> categoryInfoList, Integer categoryType) {
        for (MerchantGoodsCategoryRelationEntity category : categoryInfoList) {
            if (!categoryType.equals(category.getType())) continue;
            return category.getSubType();
        }
        return 0;
    }

    private void setBuyType(QueryGoodsParam param, QueryGoodsDTO queryGoodsDTO) {
        if (Objects.equals(3, param.getQueryType()) || Objects.equals(PlatformEnum.WEB.getCode(), param.getPlatform())) {
            int orderNum = this.marketIntegrationService.hasUserOrder(param.getGoodsId(), param.getUserId());
            queryGoodsDTO.setBuyType(Integer.valueOf(orderNum > 0 ? 1 : 0));
        } else {
            queryGoodsDTO.setBuyType(Integer.valueOf(0));
        }
    }

    @Override
    public Message update(GoodsUpdateParam goodsUpdateParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsUpdateParam.getGoodsId());
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (goodsUpdateParam.getName().length() > this.merchantGoodsInfoProperties.getGoodsNameLength()) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u540d\u79f0\u8bf7\u63a7\u5236\u57281-" + this.merchantGoodsInfoProperties.getGoodsNameLength() + "\u5b57\u7b26\u4e4b\u95f4");
        }
        MerchantGoodsVo goodsVo = new MerchantGoodsVo();
        BeanUtils.copyProperties((Object)goodsUpdateParam, (Object)goodsVo);
        this.goodsCheck(goodsVo);
        goodsVo.setId(goodsUpdateParam.getGoodsId());
        goodsVo.setTotalNum(this.countTotalNum(goodsUpdateParam.getNum(), merchantGoodsVo));
        goodsVo.setVersion(merchantGoodsVo.getVersion());
        boolean result = this.compare(goodsUpdateParam);
        if (result) {
            goodsVo.setQualificationStatus(Integer.valueOf(1));
            goodsVo.setShelfType(Integer.valueOf(0));
        }
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(goodsVo) == 0) {
            if (log.isDebugEnabled()) {
                log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)goodsVo);
            }
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
        }
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsVo.getId() + ""});
        this.addLog(merchantGoodsVo);
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        return Message.build((boolean)true);
    }

    @Override
    public Message getMerchantInfo(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantId);
        MerchantDto merchantDto = new MerchantDto();
        if (merchantInfo != null) {
            BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantDto);
            merchantDto.setMerchantId(merchantInfo.getId());
            merchantDto.setAddress(this.getAddress(merchantInfo));
            merchantDto.setHeadPics(StringUtils.isNotBlank((String)merchantInfo.getHeadPics()) ? Arrays.asList(merchantInfo.getHeadPics().split(",")).get(0) : null);
            return Message.build((boolean)true).addParam("merchantDto", (Object)merchantDto);
        }
        return Message.build((boolean)true).addParam("merchantDto", (Object)merchantDto);
    }

    @Override
    public PageWarper<MerchantGoodsListVo> queryGoodsListAll(QueryAllGoodsParam queryAllGoodsParam) {
        switch (queryAllGoodsParam.getType()) {
            case 0: {
                queryAllGoodsParam.setType(Integer.valueOf(1));
                return this.convert(this.merchantGoodsMapper.selectByshelfType(queryAllGoodsParam));
            }
            case 1: {
                return this.convert(this.merchantGoodsMapper.selectByqualification(queryAllGoodsParam));
            }
            case 2: {
                return this.convert(this.merchantGoodsMapper.selectByshelfAndSum(queryAllGoodsParam));
            }
            case 3: {
                queryAllGoodsParam.setType(Integer.valueOf(0));
                return this.convert(this.merchantGoodsMapper.selectByshelfType(queryAllGoodsParam));
            }
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    private PageWarper<MerchantGoodsListVo> convert(List<MerchantGoodsListVo> merchantGoodsListVoList) {
        if (!CollectionUtils.isEmpty(merchantGoodsListVoList)) {
            merchantGoodsListVoList.forEach(merchantGoodsListVo -> {
                if (merchantGoodsListVo != null) {
                    merchantGoodsListVo.setImg(StringUtils.isNotBlank((String)merchantGoodsListVo.getHeadPics()) ? Arrays.asList(merchantGoodsListVo.getHeadPics().split(",")).get(0) : null);
                    merchantGoodsListVo.setSaleNum(Integer.valueOf(merchantGoodsListVo.getTotalNum() - merchantGoodsListVo.getNum()));
                    merchantGoodsListVo.setGoodsId(merchantGoodsListVo.getId());
                    BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(merchantGoodsListVo.getPrice(), merchantGoodsListVo.getVipDiscount());
                    merchantGoodsListVo.setVipPrice(vipPrice);
                    BigDecimal discount = GoodsPriceRelatedUtils.getDiscount(merchantGoodsListVo.getPrice(), merchantGoodsListVo.getVipDiscount(), merchantGoodsListVo.getOriginalPrice(), vipPrice);
                    merchantGoodsListVo.setDiscount(discount);
                    if (Objects.equals(merchantGoodsListVo.getPosterStatus(), GoodsPosterStatusEnum.OFF.getStatus())) {
                        merchantGoodsListVo.setPosterUrl("");
                    }
                }
            });
            return new PageWarper(merchantGoodsListVoList);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    @Override
    public Message queryExampleGoods(Long merchantId) {
        ExampleGoodsDTO exampleGoodsDTO = new ExampleGoodsDTO();
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantId);
        if (Objects.isNull(merchantInfo)) {
            exampleGoodsDTO.setType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
        }
        MerchantGoodsSampleVO merchantGoodsSampleVO = this.merchantGoodsSampleMapper.selectByPrimaryKey(merchantInfo.getCategoryId());
        if (Objects.isNull(merchantGoodsSampleVO)) {
            exampleGoodsDTO.setType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
        }
        if (Objects.isNull(merchantGoodsSampleVO.getSampleId())) {
            exampleGoodsDTO.setType(Integer.valueOf(0));
            return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
        }
        MerchantGoodsVo merchantGoodsVo = this.merchantGoodsMapper.selectByPrimaryKey(merchantGoodsSampleVO.getSampleId());
        if (Objects.isNull(merchantGoodsVo)) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORGOODSMES.getDesc());
        }
        exampleGoodsDTO.setGoodsId(merchantGoodsVo.getId());
        exampleGoodsDTO.setImg(StringUtils.isNotBlank((String)merchantGoodsVo.getHeadPics()) ? Arrays.asList(merchantGoodsVo.getHeadPics().split(",")).get(0) : null);
        exampleGoodsDTO.setType(Integer.valueOf(1));
        exampleGoodsDTO.setName(merchantGoodsVo.getName());
        exampleGoodsDTO.setNum(merchantGoodsVo.getNum());
        exampleGoodsDTO.setOriginalPrice(merchantGoodsVo.getOriginalPrice());
        exampleGoodsDTO.setPrice(merchantGoodsVo.getPrice());
        exampleGoodsDTO.setSaleNum(Objects.nonNull(merchantGoodsVo.getNum()) && Objects.nonNull(merchantGoodsVo.getTotalNum()) ? Integer.valueOf(merchantGoodsVo.getTotalNum() - merchantGoodsVo.getNum()) : null);
        return Message.build((boolean)true).addParam("exampleGoodsDTO", (Object)exampleGoodsDTO);
    }

    @Override
    public Message queryAllGoodsSum(Long merchantId) {
        AllGoodsSumDTO allGoodsSumDTO = new AllGoodsSumDTO();
        MerchantGoodstotalVo merchantGoodstotalVo = this.merchantGoodsMapper.selectByqualificationTatal(merchantId);
        if (merchantGoodstotalVo != null) {
            allGoodsSumDTO.setAuditSum(merchantGoodstotalVo.getTotal());
        }
        if ((merchantGoodstotalVo = this.merchantGoodsMapper.selectByshelfTypeTatal(Integer.valueOf(0), merchantId)) != null) {
            allGoodsSumDTO.setShelfDownSum(merchantGoodstotalVo.getTotal());
        }
        if ((merchantGoodstotalVo = this.merchantGoodsMapper.selectByshelfTypeTatal(Integer.valueOf(1), merchantId)) != null) {
            allGoodsSumDTO.setShelfUpSum(merchantGoodstotalVo.getTotal());
        }
        if ((merchantGoodstotalVo = this.merchantGoodsMapper.selectByshelfAndSumTatal(merchantId)) != null) {
            allGoodsSumDTO.setShelfOutSum(merchantGoodstotalVo.getTotal());
        }
        return Message.build((boolean)true).addParam("allGoodsSumDTO", (Object)allGoodsSumDTO);
    }

    @Override
    public Message delete(GoodsIdParam goodsIdParam) {
        MerchantGoodsVo goodsInfo = this.merchantGoodsCache.getGoodsInfo(goodsIdParam.getGoodsId());
        this.merchantGoodsMapper.deleteByPrimaryKey(goodsIdParam.getGoodsId());
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{goodsIdParam.getGoodsId() + ""});
        this.memberDayGoodsCacheManage.resetCountActivityCount(goodsInfo.getMerchantId());
        return Message.build((boolean)true);
    }

    @Override
    public Message shelf(ShelfByUserParam shelfByUserParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(shelfByUserParam.getGoodsId());
        if (this.getGoodsInfo(shelfByUserParam.getGoodsId()) == null) {
            return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType())) {
            return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u6ca1\u6709\u5ba1\u6838\u6210\u529f,\u4e0d\u80fd\u4e0a\u4e0b\u67b6");
        }
        if (Objects.equals(shelfByUserParam.getType(), 1) || Objects.equals(shelfByUserParam.getType(), 0)) {
            MerchantGoodsVo goodsVo = new MerchantGoodsVo();
            goodsVo.setId(shelfByUserParam.getGoodsId());
            goodsVo.setShelfType(shelfByUserParam.getType());
            goodsVo.setVersion(merchantGoodsVo.getVersion());
            if (this.merchantGoodsMapper.updateByPrimaryKeySelective(goodsVo) == 0) {
                if (log.isDebugEnabled()) {
                    log.debug(MerchantGoodsEnum.FAILMES.getDesc(), (Object)goodsVo);
                }
                return Message.build((boolean)false, (String)"\u66f4\u65b0\u5931\u8d25");
            }
        }
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{shelfByUserParam.getGoodsId() + ""});
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        return Message.build((boolean)true, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public Message auditByUser(AuditByUserParam auditByUserParam) {
        String mes = this.checkAuditByUser(auditByUserParam);
        if (StringUtils.isNotBlank((String)mes)) {
            return Message.build((boolean)false, (String)mes);
        }
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        merchantGoodsVo.setId(auditByUserParam.getGoodsId());
        merchantGoodsVo.setQualificationStatus(auditByUserParam.getType());
        this.merchantGoodsMapper.updateByGoodsId(merchantGoodsVo);
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{auditByUserParam.getGoodsId() + ""});
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        return Message.build((boolean)true);
    }

    private String checkAuditByUser(AuditByUserParam auditByUserParam) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(auditByUserParam.getGoodsId());
        if (this.getGoodsInfo(auditByUserParam.getGoodsId()) == null) {
            return "\u8be5\u5546\u54c1\u4e0d\u5b58\u5728";
        }
        if (Objects.equals(auditByUserParam.getType(), 0) && !Objects.equals(merchantGoodsVo.getQualificationStatus(), 1)) {
            return "\u8be5\u5546\u54c1\u4e0d\u5728\u5ba1\u6838\u4e2d";
        }
        if (Objects.equals(auditByUserParam.getType(), 1) && !Objects.equals(merchantGoodsVo.getQualificationStatus(), 0)) {
            return "\u8be5\u5546\u54c1\u4e0d\u5728\u5f85\u5ba1\u6838\u4e2d";
        }
        return null;
    }

    @Override
    public Message queryGoodsList(Long merchantId) {
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantId);
        if (Objects.isNull(merchantInfo)) {
            return Message.build((boolean)false, (String)MerchantGoodsEnum.ERRORMERCHANTMES.getDesc());
        }
        List merchantGoodsVos = this.merchantGoodsMapper.selectByMerchantId(merchantId, Integer.valueOf(10));
        List goodsListDTOList = merchantGoodsVos.stream().map(merchantGoodsVo -> {
            GoodsListDTO goodsListDTO = new GoodsListDTO();
            if (Objects.nonNull(merchantGoodsVo)) {
                BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)goodsListDTO);
                if (StringUtils.isNotBlank((String)merchantGoodsVo.getHeadPics())) {
                    goodsListDTO.setImg(this.getFirstImg(merchantGoodsVo.getHeadPics()));
                }
                BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(merchantGoodsVo.getPrice(), merchantGoodsVo.getVipDiscount());
                goodsListDTO.setVipPrice(vipPrice);
                goodsListDTO.setVipDiscount(merchantGoodsVo.getVipDiscount());
                BigDecimal discount = GoodsPriceRelatedUtils.getDiscount(merchantGoodsVo.getPrice(), goodsListDTO.getVipDiscount(), merchantGoodsVo.getOriginalPrice(), vipPrice);
                goodsListDTO.setDiscount(discount);
                goodsListDTO.setGoodsId(merchantGoodsVo.getId());
            }
            return goodsListDTO;
        }).collect(Collectors.toList());
        return Message.build((boolean)true).addParam("goodsListDTOList", goodsListDTOList);
    }

    private String getFirstImg(String goodsImg) {
        String[] imgs;
        if (StringUtils.isNotBlank((String)goodsImg) && goodsImg.contains(",") && (imgs = goodsImg.split(",")).length > 0) {
            return imgs[0];
        }
        return goodsImg;
    }

    @Override
    public Message sort(SortParam sortParam) {
        MerchantGoodsVo merchantGoodsVo = new MerchantGoodsVo();
        merchantGoodsVo.setId(sortParam.getUpGoodsId());
        merchantGoodsVo.setSort(sortParam.getDownGoodsSort());
        this.merchantGoodsMapper.updateByGoodsId(merchantGoodsVo);
        merchantGoodsVo.setId(sortParam.getDownGoodsId());
        merchantGoodsVo.setSort(sortParam.getUpGoodsSort());
        this.merchantGoodsMapper.updateByGoodsId(merchantGoodsVo);
        return Message.build((boolean)true);
    }

    @Override
    public Message collection(GoodsLikeParam goodsLikeParam) {
        if (Objects.equals(goodsLikeParam.getType(), 0)) {
            MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsLikeParam.getGoodsId());
            if (merchantGoodsVo == null || Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_DOWN.getType())) {
                return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u88ab\u4e0b\u67b6,\u4e0d\u80fd\u88ab\u6536\u85cf");
            }
            MerchantGoodsUserFavoriteVo merchantGoodsUserFavoriteVo = this.merchantGoodsUserFavoriteMapper.selectByUserAndGoods(goodsLikeParam.getUserId(), goodsLikeParam.getGoodsId());
            if (Objects.isNull(merchantGoodsUserFavoriteVo)) {
                MerchantGoodsUserFavoriteVo favoriteVo = new MerchantGoodsUserFavoriteVo();
                favoriteVo.setCreateTime(new Date());
                favoriteVo.setModifyTime(new Date());
                BeanUtils.copyProperties((Object)goodsLikeParam, (Object)favoriteVo);
                this.merchantGoodsUserFavoriteMapper.insertSelective(favoriteVo);
            } else {
                if (Objects.equals(merchantGoodsUserFavoriteVo.getStatus(), 1)) {
                    return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u7ecf\u5728\u6536\u85cf\u4e2d,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
                }
                BeanUtils.copyProperties((Object)goodsLikeParam, (Object)merchantGoodsUserFavoriteVo);
                merchantGoodsUserFavoriteVo.setId(merchantGoodsUserFavoriteVo.getId());
                merchantGoodsUserFavoriteVo.setStatus(Integer.valueOf(1));
                merchantGoodsUserFavoriteVo.setModifyTime(new Date());
                this.merchantGoodsUserFavoriteMapper.updateByPrimaryKey(merchantGoodsUserFavoriteVo);
            }
            return Message.build((boolean)true);
        }
        if (Objects.equals(goodsLikeParam.getType(), 1)) {
            MerchantGoodsUserFavoriteVo merchantGoodsUserFavoriteVo = this.merchantGoodsUserFavoriteMapper.selectByUserAndGoods(goodsLikeParam.getUserId(), goodsLikeParam.getGoodsId());
            if (Objects.isNull(merchantGoodsUserFavoriteVo)) {
                return Message.build((boolean)false, (String)"\u8be5\u7528\u6237\u672a\u6536\u85cf\u8be5\u5546\u54c1");
            }
            if (Objects.equals(merchantGoodsUserFavoriteVo.getStatus(), 0)) {
                return Message.build((boolean)false, (String)"\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u53d6\u6d88\u6536\u85cf,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
            }
            BeanUtils.copyProperties((Object)goodsLikeParam, (Object)merchantGoodsUserFavoriteVo);
            merchantGoodsUserFavoriteVo.setStatus(Integer.valueOf(0));
            merchantGoodsUserFavoriteVo.setModifyTime(new Date());
            this.merchantGoodsUserFavoriteMapper.updateByPrimaryKey(merchantGoodsUserFavoriteVo);
            return Message.build((boolean)true);
        }
        return Message.build((boolean)true);
    }

    @Override
    public PageWarper<CollectionListDTO> collectionList(CollectionListParam collectionListParam) {
        List merchantGoodsUserFavoriteVos = this.merchantGoodsUserFavoriteMapper.collectionList(collectionListParam);
        if (!CollectionUtils.isEmpty((Collection)merchantGoodsUserFavoriteVos)) {
            merchantGoodsUserFavoriteVos.forEach(merchantGoodsUserFavoriteVo -> {
                if (Objects.nonNull(merchantGoodsUserFavoriteVo)) {
                    merchantGoodsUserFavoriteVo.setHeadPics(StringUtils.isNotBlank((String)merchantGoodsUserFavoriteVo.getHeadPics()) ? Arrays.asList(merchantGoodsUserFavoriteVo.getHeadPics().split(",")).get(0) : null);
                    merchantGoodsUserFavoriteVo.setCollectTime(merchantGoodsUserFavoriteVo.getModifyTime());
                }
            });
            return new PageWarper(merchantGoodsUserFavoriteVos);
        }
        return new PageWarper((List)Lists.newArrayList());
    }

    private MerchantGoodsVo getGoodsInfo(Long goodsId) {
        return this.merchantGoodsCache.getGoodsInfo(goodsId);
    }

    @Override
    public Boolean stockGoods(Long goodsId, Integer num) {
        log.info("\u5546\u54c1: {} \u64cd\u4f5c\u5e93\u5b58: {}", (Object)goodsId, (Object)num);
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        if (merchantGoodsVo == null) {
            return false;
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (merchantInfo == null) {
            return false;
        }
        int sum = merchantGoodsVo.getNum();
        if (sum <= 0 && num > 0) {
            return false;
        }
        if (num < 0) {
            num = Math.abs(num);
            sum += num.intValue();
        } else {
            sum -= num.intValue();
        }
        if (sum < 0) {
            return false;
        }
        MerchantGoodsVo update = new MerchantGoodsVo();
        update.setId(goodsId);
        update.setNum(Integer.valueOf(sum));
        update.setVersion(merchantGoodsVo.getVersion());
        if (this.merchantGoodsMapper.updateByPrimaryKeySelective(update) == 0) {
            log.warn("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25 goodsId: {}, num: {}", (Object)goodsId, (Object)num);
            return false;
        }
        if (Objects.equals(update.getNum(), 10)) {
            this.pushIntegrationService.pushGoodsMsg(merchantGoodsVo, merchantInfo, MerchantGoodsEnum.PUSH_GOODS_LESSTEN, null);
        }
        if (update.getNum() <= 0) {
            this.pushIntegrationService.pushGoodsMsg(merchantGoodsVo, merchantInfo, MerchantGoodsEnum.PUSH_GOODS_SELLOUT, null);
            this.memberDayGoodsCacheManage.resetCountActivityCount(merchantGoodsVo.getMerchantId());
        }
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_GOODS_KEY, new String[]{merchantGoodsVo.getId() + ""});
        return true;
    }

    @Override
    public Message checkGoodsStatus(Long goodsId, Integer num, Long userId) {
        log.info("\u7528\u6237: {}\u8d2d\u4e70\u5546\u54c1: {} \u4e2a\u6570: {}", (Object)userId, (Object)goodsId, (Object)num);
        MerchantGoodsVo goodsInfo = this.getGoodsInfo(goodsId);
        if (Objects.isNull(goodsInfo)) {
            return Message.build((boolean)false, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(goodsInfo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType())) {
            return Message.build((boolean)false, (String)"\u5546\u54c1\u4e0d\u662f\u53ef\u8d2d\u4e70\u72b6\u6001");
        }
        if (!Objects.equals(goodsInfo.getShelfType(), 1)) {
            return Message.build((boolean)false, (String)"\u5546\u54c1\u5df2\u4e0b\u67b6");
        }
        if (Objects.isNull(goodsInfo.getNum()) || Objects.isNull(num) || goodsInfo.getNum() - num < 0) {
            return Message.build((boolean)false, (String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        List categoryByGoodsId = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(goodsId);
        Message res = Message.build();
        categoryByGoodsId.forEach(p -> {
            if (Objects.equals(p.getType(), 1) && !Objects.equals(p.getStatus(), 1)) {
                res.setSuccess(false);
                res.setMessage("\u5546\u54c1\u5df2\u4e0b\u67b6");
            }
        });
        return res;
    }

    @Override
    public GoodsInfoAndUserIdDTO getByGoodsId(Long goodsId) {
        GoodsInfoAndUserIdDTO entity = this.merchantGoodsMapper.getGoodsInfoAndMerchant(goodsId);
        if (null != entity && com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)entity.getGoodsImg())) {
            entity.setGoodsImg(entity.getGoodsImg().split(",")[0]);
        }
        if (entity != null) {
            entity.setGoodsCategory(this.getGoodsCategoryType(goodsId));
        }
        return entity;
    }

    private Integer countTotalNum(Integer num, MerchantGoodsVo merchantGoodsVo) {
        Integer totalNum = merchantGoodsVo.getTotalNum();
        Integer oldNum = merchantGoodsVo.getNum();
        if (!Objects.equals(oldNum, num)) {
            if (num > oldNum) {
                int result = num - oldNum;
                totalNum = totalNum + result;
            } else {
                int result = oldNum - num;
                totalNum = totalNum - result;
            }
        }
        return totalNum;
    }

    private void addLog(MerchantGoodsVo merchantGoodsVo) {
        MerchantGoodsRecordVO merchantGoodsRecordVO = new MerchantGoodsRecordVO();
        BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantGoodsRecordVO);
        merchantGoodsRecordVO.setGoodsId(merchantGoodsVo.getId());
        merchantGoodsRecordVO.setId(null);
        merchantGoodsRecordVO.setCreateTime(new Date());
        this.merchantGoodsRecordMapper.insertSelective(merchantGoodsRecordVO);
    }

    private String goodsCheck(MerchantGoodsVo merchantGoodsVo) {
        if (merchantGoodsVo.getNum() <= 0) {
            return "\u5e93\u5b58\u4e0d\u80fd\u4e3a0";
        }
        if (merchantGoodsVo.getOriginalPrice().doubleValue() < 1.0) {
            return "\u539f\u4ef7\u6700\u4f4e\u53ef\u8bbe\u4e3a1\u5143";
        }
        if (merchantGoodsVo.getOriginalPrice().doubleValue() < 0.01) {
            return "\u73b0\u4ef7\u6700\u4f4e\u53ef\u8bbe\u4e3a0.01\u5143";
        }
        if (merchantGoodsVo.getPrice().doubleValue() > merchantGoodsVo.getOriginalPrice().doubleValue()) {
            return "\u5546\u54c1\u73b0\u4ef7\u4e0d\u80fd\u5927\u4e8e\u539f\u4ef7";
        }
        if (merchantGoodsVo.getCommissionRate() > MerchantGoodsEnum.GOODS_RATE_MAX.getType() || merchantGoodsVo.getCommissionRate() < 1) {
            return "\u4f63\u91d1\u6bd4\u4f8b\uff0c\u6700\u4f4e\u4e0d\u5c0f\u4e8e1%\uff0c\u6700\u9ad8\u4e0d\u8d85\u8fc799%";
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (Objects.isNull(merchantInfo)) {
            return "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        return null;
    }

    private String getAddress(MerchantInfo merchantInfo) {
        if (StringUtils.isNotBlank((String)merchantInfo.getCityCode()) && StringUtils.isNotBlank((String)merchantInfo.getCountyCode())) {
            StringBuilder str = new StringBuilder();
            LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(merchantInfo.getCityCode());
            if (StringUtils.isNotBlank((String)locationDTO.getFullName())) {
                str.append(locationDTO.getFullName());
            }
            if (StringUtils.isNotBlank((String)(locationDTO = this.locationIntegrationService.getLocationByGeocode(merchantInfo.getCountyCode())).getName())) {
                str.append(locationDTO.getName());
            }
            str.append(merchantInfo.getAddress());
            return str.toString();
        }
        return null;
    }

    private boolean compare(GoodsUpdateParam goodsUpdateParam) {
        MerchantGoodsRecordVO merchantGoodsRecordVO = this.merchantGoodsRecordMapper.selectByPrimaryKey(goodsUpdateParam.getGoodsId());
        if (merchantGoodsRecordVO != null) {
            GoodsCompare newGoods = new GoodsCompare();
            BeanUtils.copyProperties((Object)goodsUpdateParam, (Object)newGoods);
            newGoods.setPrice(goodsUpdateParam.getPrice().doubleValue());
            newGoods.setOriginalPrice(goodsUpdateParam.getOriginalPrice().doubleValue());
            GoodsCompare oldGoods = new GoodsCompare();
            BeanUtils.copyProperties((Object)merchantGoodsRecordVO, (Object)oldGoods);
            oldGoods.setPrice(merchantGoodsRecordVO.getPrice().doubleValue());
            oldGoods.setOriginalPrice(merchantGoodsRecordVO.getOriginalPrice().doubleValue());
            if (Objects.equals(newGoods, oldGoods)) {
                return false;
            }
            return Objects.equals(merchantGoodsRecordVO.getNum(), goodsUpdateParam.getNum()) && Objects.equals(merchantGoodsRecordVO.getVipDiscount(), goodsUpdateParam.getVipDiscount()) && Objects.equals(merchantGoodsRecordVO.getCommissionRate(), goodsUpdateParam.getCommissionRate());
        }
        return true;
    }

    @Override
    public void shelfDownAllGoods(Long merchantId) {
        this.merchantGoodsMapper.shelfDownAllGoods(merchantId);
        List goodIds = this.merchantGoodsMapper.getGoodIdsForMerchant(merchantId);
        goodIds.forEach(this.merchantGoodsCache::refreshGoodsCache);
        this.memberDayGoodsCacheManage.resetCountActivityCount(merchantId);
    }

    @Override
    public List<MerchantWorkGoodsDTO> queryWorkGoods(Long merchantId) {
        List workGoodsList = this.merchantGoodsMapper.getWorkGoodsList(merchantId);
        ArrayList<MerchantWorkGoodsDTO> goodsDTOList = new ArrayList<MerchantWorkGoodsDTO>();
        if (!CollectionUtils.isEmpty((Collection)workGoodsList)) {
            workGoodsList.forEach(merchantGoodsVo -> {
                if (merchantGoodsVo != null) {
                    MerchantWorkGoodsDTO merchantWorkGoodsDTO = new MerchantWorkGoodsDTO();
                    BeanUtils.copyProperties((Object)merchantGoodsVo, (Object)merchantWorkGoodsDTO);
                    merchantWorkGoodsDTO.setGoodsId(merchantGoodsVo.getId());
                    merchantWorkGoodsDTO.setVipPrice(merchantGoodsVo.getPrice().multiply(new BigDecimal("0.05")).setScale(2, 4));
                    goodsDTOList.add(merchantWorkGoodsDTO);
                }
            });
            log.debug(((Object)goodsDTOList).toString());
            return goodsDTOList;
        }
        return null;
    }

    @Override
    public MerchantInfoSimpleVO getSimpleMerchantInfoByGoodsId(Long goodsId) {
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        if (Objects.isNull(merchantGoodsVo)) {
            return null;
        }
        MerchantInfo merchantInfo = this.merchantInfoDbService.getMerchantInfo(merchantGoodsVo.getMerchantId());
        if (Objects.isNull(merchantInfo)) {
            return null;
        }
        MerchantInfoSimpleVO merchantInfoSimpleVO = new MerchantInfoSimpleVO();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantInfoSimpleVO);
        return merchantInfoSimpleVO;
    }

    @Override
    public Message judgeGoodsBuy(Long goodsId) {
        String errorStr = "\u5546\u54c1\u5df2\u4e0b\u67b6\uff0c\u70b9\u6211\u7684\u5934\u50cf\u8fdb\u5e97\u4eab\u66f4\u591a\u4f18\u60e0\u54e6";
        log.info("\u70b9\u51fb\u62a2\u8d2d\u5546\u54c1id :{}", (Object)goodsId);
        MerchantGoodsVo merchantGoodsVo = this.getGoodsInfo(goodsId);
        if (merchantGoodsVo == null) {
            return Message.build((boolean)false, (String)errorStr);
        }
        if (!Objects.equals(merchantGoodsVo.getQualificationStatus(), MerchantGoodsEnum.AUDIT_GOODS_SUCCESS.getType())) {
            return Message.build((boolean)false, (String)errorStr);
        }
        if (Objects.equals(merchantGoodsVo.getShelfType(), MerchantGoodsEnum.GOODS_SHELF_DOWN.getType())) {
            return Message.build((boolean)false, (String)errorStr);
        }
        return Message.build();
    }

    @Override
    public Integer getGoodsCategoryType(Long goodsId) {
        List goodsCategoryInfo = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(goodsId);
        Set goodsCategoryTypeSet = goodsCategoryInfo.stream().map(MerchantGoodsCategoryRelationEntity::getType).collect(Collectors.toSet());
        if (goodsCategoryTypeSet.contains(GoodsCategoryTypeEnum.MEMBER_DAY.getCode())) {
            return GoodsCategoryTypeEnum.MEMBER_DAY.getCode();
        }
        if (goodsCategoryTypeSet.contains(GoodsCategoryTypeEnum.ORDINARY.getCode())) {
            if (goodsCategoryTypeSet.contains(GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode())) {
                return GoodsCategoryTypeEnum.DISCOUNT_GROUP.getCode();
            }
            return GoodsCategoryTypeEnum.ORDINARY.getCode();
        }
        log.error("\u5546\u54c1\u7c7b\u578b\u9519\u8bef\uff0c\u5546\u54c1id\uff1a{}", (Object)goodsId);
        return GoodsCategoryTypeEnum.ORDINARY.getCode();
    }

    private String getWeekNameByCount(int weekDay) {
        if (1 == weekDay) {
            return "\u4e00";
        }
        if (2 == weekDay) {
            return "\u4e8c";
        }
        if (3 == weekDay) {
            return "\u4e09";
        }
        if (4 == weekDay) {
            return "\u56db";
        }
        if (5 == weekDay) {
            return "\u4e94";
        }
        if (6 == weekDay) {
            return "\u516d";
        }
        if (0 == weekDay) {
            return "\u65e5";
        }
        return "";
    }

    @Override
    public GoodsCommissionDTO getCommission(Long goodsId, Boolean isVip) {
        MerchantGoodsVo goodsInfo = this.getGoodsInfo(goodsId);
        if (goodsInfo == null) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4f63\u91d1\u4fe1\u606f\uff0c\u5546\u54c1\u4e0d\u5b58\u5728,goodsId:{}", (Object)goodsId);
            return null;
        }
        List categoryByGoodsId = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(goodsId);
        if (categoryByGoodsId.isEmpty()) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4f63\u91d1\u4fe1\u606f\uff0c\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cgoodsId:{}", (Object)goodsId);
            return null;
        }
        AtomicReference merchantGoodsCategoryRelationEntity = new AtomicReference();
        AtomicBoolean memberDayGoods = new AtomicBoolean(false);
        categoryByGoodsId.forEach(categoryGoods -> {
            if (categoryGoods.getType().equals(GoodsCategoryTypeEnum.MEMBER_DAY.getCode())) {
                memberDayGoods.set(true);
                merchantGoodsCategoryRelationEntity.set(categoryGoods);
            }
        });
        if (memberDayGoods.get()) {
            MerchantGoodsCategoryRelationEntity categoryRelationEntity = (MerchantGoodsCategoryRelationEntity)merchantGoodsCategoryRelationEntity.get();
            MemberDayGoodsCategoryExtDataDTO extDataDTO = (MemberDayGoodsCategoryExtDataDTO)JSON.parseObject((String)categoryRelationEntity.getExtData(), MemberDayGoodsCategoryExtDataDTO.class);
            if (extDataDTO == null) {
                log.error("\u4e94\u6298\u4f1a\u5458\u65e5 \u6269\u5c55\u5b57\u6bb5\u4e0d\u5b58\u5728extDataDTO:{}\uff0cgoodsId:{}", (Object)extDataDTO, (Object)goodsId);
                return null;
            }
            GoodsCommissionDTO goodsCommissionDTO = GoodsCommissionDTO.builder().smallTalentCommission(extDataDTO.getNoBigTalentCommission()).midTalentCommission(extDataDTO.getNoBigTalentCommission()).bigTalentCommission(extDataDTO.getBigTalentCommission()).parentCommission(extDataDTO.getTeamCommission()).grandparentCommission(extDataDTO.getTeamCommission()).totalCommission(goodsInfo.getCommissionAmount()).build();
            return goodsCommissionDTO;
        }
        BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(goodsInfo.getPrice(), goodsInfo.getVipDiscount());
        CalculateUserCommissionDTO commissionDTO = CalculateUserCommissionDTO.builder().commissionType(goodsInfo.getCommissionType()).commissionRate(goodsInfo.getCommissionRate()).price(vipPrice).commissionCount(goodsInfo.getCommissionAmount()).build();
        GoodsCommissionDTO goodsCommissionDTO = GoodsCommissionDTO.builder().build();
        goodsCommissionDTO.setTotalCommission(GoodsPriceRelatedUtils.getTotalCommission(isVip != false ? vipPrice : goodsInfo.getPrice(), goodsInfo.getCommissionRate()));
        return this.getDiffTalentCommission(goodsCommissionDTO, commissionDTO);
    }

    private GoodsCommissionDTO getDiffTalentCommission(GoodsCommissionDTO goodsCommissionDTO, CalculateUserCommissionDTO commissionDTO) {
        commissionDTO.setTalentLevel(TalentLevelEnum.SMALL_TALENT.getCode());
        commissionDTO.setGroupCommission(Boolean.valueOf(false));
        goodsCommissionDTO.setSmallTalentCommission(GoodsPriceRelatedUtils.getUserResultCommission(commissionDTO));
        goodsCommissionDTO.setSmallTalentCommissionRate(this.merchantGoodsRateProperties.getSmallTalentRebate());
        commissionDTO.setTalentLevel(TalentLevelEnum.MIDDLE_TALENT.getCode());
        goodsCommissionDTO.setMidTalentCommission(GoodsPriceRelatedUtils.getUserResultCommission(commissionDTO));
        goodsCommissionDTO.setSmallTalentCommissionRate(this.merchantGoodsRateProperties.getMidTalentRebate());
        commissionDTO.setTalentLevel(TalentLevelEnum.BIG_TALENT.getCode());
        goodsCommissionDTO.setBigTalentCommission(GoodsPriceRelatedUtils.getUserResultCommission(commissionDTO));
        goodsCommissionDTO.setSmallTalentCommissionRate(this.merchantGoodsRateProperties.getBigTalentRebate());
        commissionDTO.setGroupCommission(Boolean.valueOf(true));
        goodsCommissionDTO.setParentCommission(GoodsPriceRelatedUtils.getUserResultCommission(commissionDTO));
        goodsCommissionDTO.setSmallTalentCommissionRate(this.merchantGoodsRateProperties.getTeamCommissionRebate());
        goodsCommissionDTO.setGrandparentCommission(GoodsPriceRelatedUtils.getUserResultCommission(commissionDTO));
        goodsCommissionDTO.setSmallTalentCommissionRate(this.merchantGoodsRateProperties.getTeamCommissionRebate());
        return goodsCommissionDTO;
    }

    private BigDecimal getCommissionByUserId(Long userId, Long goodsId) {
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId);
        MerchantGoodsVo goodsInfo = this.getGoodsInfo(goodsId);
        List categoryByGoodsId = this.merchantGoodsCategoryRelationMapper.findCategoryByGoodsId(goodsId);
        if (categoryByGoodsId.isEmpty()) {
            log.error("\u67e5\u8be2\u5546\u54c1\u4f63\u91d1\u4fe1\u606f\uff0c\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cuserId:{},goodsId:{}", (Object)userId, (Object)goodsId);
            return BigDecimal.ZERO;
        }
        AtomicReference<MerchantGoodsCategoryRelationEntity> merchantGoodsCategoryRelationEntity = new AtomicReference<MerchantGoodsCategoryRelationEntity>(new MerchantGoodsCategoryRelationEntity());
        AtomicBoolean memberDayGoods = new AtomicBoolean(false);
        categoryByGoodsId.forEach(categoryGoods -> {
            if (categoryGoods.getType().equals(GoodsCategoryTypeEnum.MEMBER_DAY.getCode())) {
                memberDayGoods.set(true);
                merchantGoodsCategoryRelationEntity.set((MerchantGoodsCategoryRelationEntity)categoryGoods);
            }
        });
        if (memberDayGoods.get()) {
            MerchantGoodsCategoryRelationEntity categoryRelationEntity = merchantGoodsCategoryRelationEntity.get();
            MemberDayGoodsCategoryExtDataDTO extDataDTO = (MemberDayGoodsCategoryExtDataDTO)JSON.parseObject((String)categoryRelationEntity.getExtData(), MemberDayGoodsCategoryExtDataDTO.class);
            return GoodsPriceRelatedUtils.getMemberDayGoodsCommission(userInfoDTO.getTalentLevel(), false, extDataDTO);
        }
        BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(goodsInfo.getPrice(), goodsInfo.getVipDiscount());
        CalculateUserCommissionDTO commissionDTO = CalculateUserCommissionDTO.builder().commissionType(goodsInfo.getCommissionType()).commissionRate(goodsInfo.getCommissionRate()).price(Objects.equals(userInfoDTO.getIsVip(), 1) ? vipPrice : goodsInfo.getPrice()).commissionCount(goodsInfo.getCommissionAmount()).talentLevel(userInfoDTO.getTalentLevel()).groupCommission(Boolean.valueOf(false)).build();
        return GoodsPriceRelatedUtils.getUserResultCommission(commissionDTO);
    }

    public GoodsServiceImpl(MerchantGoodsMapper merchantGoodsMapper, UserIntegrationService userIntegrationService, MerchantGoodsRecordMapper merchantGoodsRecordMapper, MerchantGoodsSampleMapper merchantGoodsSampleMapper, MerchantGoodsUserFavoriteMapper merchantGoodsUserFavoriteMapper, RedisHashMapAdapter redisHashMapAdapter, GoodAddStrategyManage goodAddStrategyManage, PushIntegrationService pushIntegrationService, LocationIntegrationService locationIntegrationService, GoodsBarrageService goodsBarrageService, MarketIntegrationService marketIntegrationService, MerchantInfoFacadeService merchantInfoDbService, MerchantGoodsCache merchantGoodsCache, MerchantGoodsRateProperties merchantGoodsRateProperties, MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, MerchantGoodsMemberDayMapper merchantGoodsMemberDayMapper, MemberDayGoodsCacheManage memberDayGoodsCacheManage, MerchantGoodsInfoProperties merchantGoodsInfoProperties) {
        this.merchantGoodsMapper = merchantGoodsMapper;
        this.userIntegrationService = userIntegrationService;
        this.merchantGoodsRecordMapper = merchantGoodsRecordMapper;
        this.merchantGoodsSampleMapper = merchantGoodsSampleMapper;
        this.merchantGoodsUserFavoriteMapper = merchantGoodsUserFavoriteMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.goodAddStrategyManage = goodAddStrategyManage;
        this.pushIntegrationService = pushIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
        this.goodsBarrageService = goodsBarrageService;
        this.marketIntegrationService = marketIntegrationService;
        this.merchantInfoDbService = merchantInfoDbService;
        this.merchantGoodsCache = merchantGoodsCache;
        this.merchantGoodsRateProperties = merchantGoodsRateProperties;
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.merchantGoodsMemberDayMapper = merchantGoodsMemberDayMapper;
        this.memberDayGoodsCacheManage = memberDayGoodsCacheManage;
        this.merchantGoodsInfoProperties = merchantGoodsInfoProperties;
    }
}

