/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.goods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.merchant.config.ActivityGoodsProperties;
import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.domain.goods.MerchantGoodsCategoryRelationMapper;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.goods.ActivityGoodsDTO;
import com.bxm.localnews.merchant.dto.goods.DiscountGroupFacadeDTO;
import com.bxm.localnews.merchant.dto.goods.MemberDayGoodsQueryDTO;
import com.bxm.localnews.merchant.dto.goods.MemberGoodsFacadeDTO;
import com.bxm.localnews.merchant.entity.goods.MemberDayGoodsCategoryExtDataDTO;
import com.bxm.localnews.merchant.integration.UserIntegrationService;
import com.bxm.localnews.merchant.param.goods.activity.MemberDayGoodsQueryParam;
import com.bxm.localnews.merchant.service.goods.MemberDayGoodsService;
import com.bxm.localnews.merchant.service.goods.cache.MemberDayGoodsCacheManage;
import com.bxm.localnews.merchant.utils.GoodsPriceRelatedUtils;
import com.bxm.localnews.merchant.vo.goods.activity.MemberDayGoodsVO;
import com.bxm.localnews.merchant.vo.goods.activity.MemberDayIndustryVO;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class MemberDayGoodsServiceImpl
implements MemberDayGoodsService {
    private static final Logger log = LoggerFactory.getLogger(MemberDayGoodsServiceImpl.class);
    private final MerchantCategoryMapper merchantCategoryMapper;
    private final MemberDayGoodsCacheManage memberDayGoodsCacheManage;
    private final MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper;
    private final ActivityGoodsProperties activityGoodsProperties;
    private final UserIntegrationService userIntegrationService;

    @Override
    public List<MemberDayGoodsVO> getList(MemberDayGoodsQueryParam param) {
        MemberDayGoodsQueryDTO queryDTO = new MemberDayGoodsQueryDTO();
        BeanUtils.copyProperties((Object)param, (Object)queryDTO);
        queryDTO.setMemberPageMemberGoodsCount(this.activityGoodsProperties.getMemberPageMemberGoodsCount());
        queryDTO.setSavePageMemberGoodsCount(this.activityGoodsProperties.getSavePageMemberGoodsCount());
        List memberDayGoodsQueryList = this.merchantGoodsCategoryRelationMapper.getMemberDayGoodsQueryList(queryDTO);
        if (2 == param.getQueryType()) {
            if (memberDayGoodsQueryList.size() > this.activityGoodsProperties.getMemberPageMemberGoodsCount()) {
                memberDayGoodsQueryList = memberDayGoodsQueryList.subList(this.activityGoodsProperties.getMemberPageMemberGoodsCount(), memberDayGoodsQueryList.size());
            } else {
                return Collections.emptyList();
            }
        }
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        memberDayGoodsQueryList.forEach(dayGoodsVO -> {
            String extData = dayGoodsVO.getExtData();
            MemberDayGoodsCategoryExtDataDTO extDataDTO = (MemberDayGoodsCategoryExtDataDTO)JSON.parseObject((String)extData, MemberDayGoodsCategoryExtDataDTO.class);
            String[] headPics = dayGoodsVO.getHeadPics().split(",");
            if (Objects.isNull(extDataDTO.getBaseSaleCount())) {
                extDataDTO.setBaseSaleCount(Integer.valueOf(0));
            }
            BigDecimal commission = GoodsPriceRelatedUtils.getMemberDayGoodsCommission(userInfoDTO.getTalentLevel(), false, extDataDTO);
            dayGoodsVO.setCommission(commission);
            dayGoodsVO.setSaleAmount(Integer.valueOf(dayGoodsVO.getTotalNum() - dayGoodsVO.getNum() + extDataDTO.getBaseSaleCount()));
            dayGoodsVO.setVipPrice(dayGoodsVO.getPrice());
            dayGoodsVO.setGoodsImg(headPics[0]);
        });
        return memberDayGoodsQueryList;
    }

    @Override
    public List<MemberDayIndustryVO> getCategoryList(String areaCode) {
        List industryInfoList = this.merchantCategoryMapper.selectAll();
        List<MemberDayIndustryVO> resultIndustryVOList = industryInfoList.stream().map(industry -> {
            MemberDayIndustryVO resultItem = new MemberDayIndustryVO();
            resultItem.setIndustryName(industry.getCatName());
            resultItem.setImgUrl(industry.getCatImg());
            resultItem.setIndustryId(industry.getId());
            Integer memberGoodsCount = this.memberDayGoodsCacheManage.getMemberGoodsCount(areaCode, industry.getId());
            resultItem.setGoodsCount(Integer.valueOf(Objects.isNull(memberGoodsCount) ? 0 : memberGoodsCount));
            return resultItem;
        }).collect(Collectors.toList());
        Optional<Integer> goodsAllCountOptional = resultIndustryVOList.stream().map(MemberDayIndustryVO::getGoodsCount).reduce(Integer::sum);
        MemberDayIndustryVO allItemVO = new MemberDayIndustryVO();
        allItemVO.setIndustryId(Long.valueOf(0L));
        allItemVO.setGoodsCount(goodsAllCountOptional.orElse(0));
        allItemVO.setImgUrl(this.activityGoodsProperties.getIndustryAllIcon());
        allItemVO.setIndustryName("\u5168\u90e8");
        resultIndustryVOList.add(0, allItemVO);
        return resultIndustryVOList;
    }

    @Override
    public ActivityGoodsDTO getLatestActivityGoods(String areaCode) {
        ActivityGoodsDTO resultDTO = new ActivityGoodsDTO();
        Date nowTime = new Date();
        Integer weekCount = this.getWeekCountByDate(nowTime);
        MemberGoodsFacadeDTO memberGoodsFacadeDTO = this.merchantGoodsCategoryRelationMapper.getLatestMemberDayGoods(areaCode, weekCount);
        if (Objects.nonNull(memberGoodsFacadeDTO)) {
            String headPics = memberGoodsFacadeDTO.getHeadPics();
            String[] headPicArray = headPics.split(",");
            resultDTO.setImg(headPicArray[0]);
            resultDTO.setPrice(memberGoodsFacadeDTO.getPrice());
            return resultDTO;
        }
        DiscountGroupFacadeDTO discountGroupFacadeDTO = this.merchantGoodsCategoryRelationMapper.getLatestDiscountGroupGoods(areaCode);
        if (Objects.nonNull(discountGroupFacadeDTO)) {
            BigDecimal vipPrice = GoodsPriceRelatedUtils.getVipPrice(discountGroupFacadeDTO.getPrice(), discountGroupFacadeDTO.getVipDiscount());
            resultDTO.setPrice(vipPrice);
            String headPics = discountGroupFacadeDTO.getHeadPics();
            String[] headImgArray = headPics.split(",");
            resultDTO.setImg(headImgArray[0]);
            return resultDTO;
        }
        return null;
    }

    public Integer getWeekCountByDate(Date targetDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(targetDate);
        return cal.get(7) - 1;
    }

    public MemberDayGoodsServiceImpl(MerchantCategoryMapper merchantCategoryMapper, MemberDayGoodsCacheManage memberDayGoodsCacheManage, MerchantGoodsCategoryRelationMapper merchantGoodsCategoryRelationMapper, ActivityGoodsProperties activityGoodsProperties, UserIntegrationService userIntegrationService) {
        this.merchantCategoryMapper = merchantCategoryMapper;
        this.memberDayGoodsCacheManage = memberDayGoodsCacheManage;
        this.merchantGoodsCategoryRelationMapper = merchantGoodsCategoryRelationMapper;
        this.activityGoodsProperties = activityGoodsProperties;
        this.userIntegrationService = userIntegrationService;
    }
}

