/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.invite.impl;

import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.facade.UserFeignService;
import com.bxm.localnews.merchant.service.invite.InviteProcessService;
import com.bxm.localnews.merchant.service.invite.InviteProcessorContext;
import com.bxm.localnews.merchant.service.invite.InviteTypeProcessorManager;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InviteProcessServiceImpl
implements InviteProcessService {
    private static final Logger log = LoggerFactory.getLogger(InviteProcessServiceImpl.class);
    private final InviteTypeProcessorManager inviteTypeProcessorManager;
    private final UserFeignService userFeignService;

    @Autowired
    public InviteProcessServiceImpl(InviteTypeProcessorManager inviteTypeProcessorManager, UserFeignService userFeignService) {
        this.inviteTypeProcessorManager = inviteTypeProcessorManager;
        this.userFeignService = userFeignService;
    }

    @Override
    public String getFinalInviteTitle(UserInviteHistoryEntity history) {
        return this.inviteTypeProcessorManager.obtain(history.getType()).decorateTitle(history);
    }

    @Override
    public String getLevelTwoFinalInviteTitle(Long userId, UserInviteHistoryEntity history) {
        if (!Objects.equals(userId, history.getInviteUserId())) {
            return "\u6765\u81ea" + ((UserInfoDTO)this.userFeignService.getUserFromCache(history.getInviteUserId()).getBody()).getNickname() + this.getFinalInviteTitle(history);
        }
        return "\u6765\u81ea\u4f60" + this.getFinalInviteTitle(history);
    }

    @Override
    public String getInviteTitle(UserInviteHistoryEntity history) {
        InviteProcessorContext context = new InviteProcessorContext();
        context.setRelationId(history.getRelationId());
        return this.inviteTypeProcessorManager.obtain(history.getType()).obtainTitle(context);
    }
}

