/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.invite.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantProAccountProperties;
import com.bxm.localnews.merchant.domain.UserInviteHistoryMapper;
import com.bxm.localnews.merchant.dto.UserInviteDTO;
import com.bxm.localnews.merchant.dto.account.MerchantAccountInfoDTO;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.param.PromoteParam;
import com.bxm.localnews.merchant.service.account.UserProAccountStrategy;
import com.bxm.localnews.merchant.service.invite.InviteProcessService;
import com.bxm.localnews.merchant.service.invite.UserInviteService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserInviteServiceImpl
extends BaseService
implements UserInviteService {
    @Resource
    private UserInviteHistoryMapper userInviteHistoryMapper;
    @Autowired
    private UserProAccountStrategy userProAccountStrategy;
    @Autowired
    private MerchantProAccountProperties merchantProAccountProperties;
    private InviteProcessService inviteProcessService;
    private RedisHashMapAdapter redisHashMapAdapter;

    private InviteProcessService getInviteProcessService() {
        if (this.inviteProcessService == null) {
            this.inviteProcessService = (InviteProcessService)SpringContextHolder.getBean(InviteProcessService.class);
        }
        return this.inviteProcessService;
    }

    @Override
    public PageWarper<UserInviteDTO> getInviteByPage(PromoteParam param) {
        PageWarper page = new PageWarper(this.userInviteHistoryMapper.queryByPage(param));
        PageWarper resultPage = new PageWarper();
        if (!CollectionUtils.isEmpty((Collection)page.getList())) {
            BeanUtils.copyProperties((Object)page, (Object)resultPage);
            resultPage.setList(this.convert(page.getList(), param.getUserId()));
        }
        return resultPage;
    }

    @Override
    public List<String> getLastInviteUserHeadImgList(Long userId) {
        List info = this.userInviteHistoryMapper.getLastInviteHeadImg(userId, 5);
        return info;
    }

    private List<UserInviteDTO> convert(List<UserInviteHistoryEntity> histories, Long userId) {
        ArrayList<UserInviteDTO> result = new ArrayList<UserInviteDTO>(histories.size());
        histories.forEach(item -> result.add(UserInviteDTO.builder().activeVip(Boolean.valueOf(Objects.equals(item.getActiveVip(), (byte)1))).inviteHeadImg(item.getInviteHeadImg()).activeType(StringUtils.isEmpty((CharSequence)item.getActiveType()) ? item.getRelationTitle() : item.getActiveType()).level(Integer.valueOf(Objects.equals(item.getInviteUserId(), userId) || Objects.equals(item.getCreatedUserId(), userId) ? 1 : 2)).promoteMoney(Objects.equals(item.getInviteUserId(), userId) || Objects.equals(item.getCreatedUserId(), userId) ? this.merchantProAccountProperties.getMasterMoney() : this.merchantProAccountProperties.getMasterTwoMoney()).inviteHeadImg(item.getInviteHeadImg()).inviteNickName(item.getInviteUserNickname()).inviteUserId(item.getUserId()).relationTitle(this.getInviteProcessService().getLevelTwoFinalInviteTitle(userId, (UserInviteHistoryEntity)item)).promoteCashMoney(Objects.equals(item.getActiveType(), InviteTypeEnum.WELFARE_VIP.name()) ? new BigDecimal("5") : null).build()));
        return result;
    }

    @Override
    public UserInviteHistoryEntity selectByUserId(Long userId) {
        UserInviteHistoryEntity bean = this.userInviteHistoryMapper.selectByUserId(userId);
        return null == bean ? new UserInviteHistoryEntity() : bean;
    }

    @Override
    public boolean insert(UserInviteHistoryEntity paramInviteInfo) {
        try {
            if (Objects.equals(paramInviteInfo.getUserId(), paramInviteInfo.getInviteUserId())) {
                return false;
            }
            if (null == paramInviteInfo.getId()) {
                paramInviteInfo.setId(Long.valueOf(this.nextId()));
            }
            paramInviteInfo.setCreateTime(new Date());
            this.userInviteHistoryMapper.insert(paramInviteInfo);
            this.addInviteProAccount(paramInviteInfo);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void addInviteProAccount(UserInviteHistoryEntity bean) {
        if (null == bean.getUserId() || null == bean.getInviteUserId()) {
            return;
        }
        if (null != bean.getInviteUserId() && !Objects.equals(bean.getInviteUserId(), 0)) {
            this.userProAccountStrategy.exection(this.getMerchantAccountInfo(bean.getUserId(), bean.getInviteUserId(), 1));
        }
        if (null != bean.getInviteSuperUserId() && !Objects.equals(bean.getInviteSuperUserId(), 0)) {
            this.userProAccountStrategy.exection(this.getMerchantAccountInfo(bean.getUserId(), bean.getInviteSuperUserId(), 2));
        }
        if (!(null == bean.getInviteCreatedUserId() || Objects.equals(bean.getInviteCreatedUserId(), bean.getCreatedUserId()) || Objects.equals(bean.getInviteCreatedUserId(), bean.getInviteSuperUserId()) || Objects.equals(bean.getInviteCreatedUserId(), 0))) {
            this.userProAccountStrategy.exection(this.getMerchantAccountInfo(bean.getUserId(), bean.getInviteCreatedUserId(), 2));
        }
        if (!(null == bean.getCreatedUserId() || Objects.equals(bean.getCreatedUserId(), bean.getInviteUserId()) || Objects.equals(bean.getCreatedUserId(), bean.getInviteSuperUserId()) || Objects.equals(bean.getCreatedUserId(), bean.getInviteCreatedUserId()) || Objects.equals(bean.getCreatedUserId(), 0))) {
            this.userProAccountStrategy.exection(this.getMerchantAccountInfo(bean.getUserId(), bean.getCreatedUserId(), 1));
        }
    }

    private MerchantAccountInfoDTO getMerchantAccountInfo(Long userId, Long inviteUserId, Integer type) {
        MerchantAccountInfoDTO merchantAccountInfoDTO = new MerchantAccountInfoDTO();
        if (Objects.equals(type, 1)) {
            merchantAccountInfoDTO.setType(MerchantAccountTypeEnum.INVITE_ONE_FRIEND);
            merchantAccountInfoDTO.setRelationTitle("\u4e00\u7ea7\u5f92\u5f1f\u5956\u52b1");
        } else if (Objects.equals(type, 2)) {
            merchantAccountInfoDTO.setType(MerchantAccountTypeEnum.INVITE_TWO_FRIEND);
            merchantAccountInfoDTO.setRelationTitle("\u4e8c\u7ea7\u5f92\u5f1f\u5956\u52b1");
        }
        merchantAccountInfoDTO.setRelationId(userId);
        merchantAccountInfoDTO.setUserId(inviteUserId);
        return merchantAccountInfoDTO;
    }
}

