/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.dto.NewsBriefInfoDto;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.integration.NewsIntegrationService;
import com.bxm.localnews.merchant.service.invite.InviteProcessorContext;
import com.bxm.localnews.merchant.service.invite.InviteTypeProcessor;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsInviteTypeProcessor
implements InviteTypeProcessor {
    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public NewsInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.NEWS;
    }

    @Override
    public String decorateTitle(UserInviteHistoryEntity inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return "\u5176\u4ed6\u5206\u4eab";
        }
        return "\u5206\u4eab\u7684\u300a" + inviteHistory.getRelationTitle() + "\u300b\u65b0\u95fb\u9080\u8bf7";
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        NewsBriefInfoDto newsInfo = this.newsIntegrationService.getNewsInfo(context.getRelationId());
        if (StringUtils.isBlank((CharSequence)newsInfo.getTitle())) {
            return "";
        }
        return newsInfo.getTitle();
    }
}

