/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.promote.impl;

import com.bxm.localnews.merchant.common.config.RedisConfig;
import com.bxm.localnews.merchant.common.enums.MerchantAccountTypeEnum;
import com.bxm.localnews.merchant.common.properties.MerchantProAccountProperties;
import com.bxm.localnews.merchant.domain.MerchantAccountMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantUserPromotionAccountMapper;
import com.bxm.localnews.merchant.domain.MerchantUserPromotionFlowMapper;
import com.bxm.localnews.merchant.domain.UserInviteHistoryMapper;
import com.bxm.localnews.merchant.entity.MerchantAccountEntity;
import com.bxm.localnews.merchant.entity.MerchantPromotionFlowEntity;
import com.bxm.localnews.merchant.entity.MerchantUserPromotionAccountEntity;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.facade.UserFeignService;
import com.bxm.localnews.merchant.service.promote.MerchantUserProAccountService;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MerchantUserProAccountServiceImpl
implements MerchantUserProAccountService {
    private static final Logger log = LoggerFactory.getLogger(MerchantUserProAccountServiceImpl.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final MerchantAccountMapper merchantAccountMapper;
    private final MerchantUserPromotionAccountMapper merchantUserPromotionAccountMapper;
    private final MerchantUserPromotionFlowMapper merchantUserPromotionFlowMapper;
    private final MerchantInfoMapper merchantInfoMapper;
    private final UserFeignService userFeignService;
    private final MerchantProAccountProperties merchantProAccountProperties;
    private final UserInviteHistoryMapper userInviteHistoryMapper;
    private final SequenceCreater sequenceCreater;

    @Override
    public MerchantUserAccountVO getUserProAccount(Long merchantId) {
        MerchantUserAccountVO redisAccountInfo = null;
        if (null == merchantId) {
            return redisAccountInfo;
        }
        redisAccountInfo = (MerchantUserAccountVO)this.redisHashMapAdapter.get(RedisConfig.MERCHANT_ACCOUNT_KEY, merchantId + "", MerchantUserAccountVO.class);
        if (null == redisAccountInfo) {
            redisAccountInfo = new MerchantUserAccountVO();
            MerchantAccountEntity merchantAccountEntity = this.merchantAccountMapper.selectByMerchantId(merchantId);
            this.convert(redisAccountInfo, merchantAccountEntity);
            MerchantUserPromotionAccountEntity userPromotionAccountEntity = this.merchantUserPromotionAccountMapper.selectByMerchantId(merchantId);
            this.convert(redisAccountInfo, userPromotionAccountEntity);
            this.redisHashMapAdapter.put(RedisConfig.MERCHANT_ACCOUNT_KEY, merchantId + "", (Object)redisAccountInfo);
        }
        return redisAccountInfo;
    }

    @Override
    public void refreshAccount(Long userId) {
        this.redisHashMapAdapter.remove(RedisConfig.MERCHANT_ACCOUNT_KEY, new String[]{userId + ""});
    }

    @Override
    public int subProAccount(MerchantUserPromotionAccountEntity accountEntity) {
        if (accountEntity.getAblePromotionCash().compareTo(new BigDecimal("0")) == 0) {
            return 1;
        }
        return this.merchantUserPromotionAccountMapper.subProAccount(accountEntity);
    }

    @Override
    public int addProAccount(MerchantUserPromotionAccountEntity accountEntity) {
        return this.merchantUserPromotionAccountMapper.addProAccount(accountEntity);
    }

    @Override
    @Async
    public Boolean initProAccount(Long userId) {
        MerchantInfo merchantInfo = new MerchantInfo();
        merchantInfo = this.merchantInfoMapper.selectByUserId(userId);
        if (null == merchantInfo) {
            log.info("\u7528\u6237\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u521d\u59cb\u5316\u5931\u8d25~");
            return false;
        }
        MerchantUserPromotionAccountEntity userPromotionAccountEntity = this.merchantUserPromotionAccountMapper.selectByMerchantId(merchantInfo.getId());
        if (null != userPromotionAccountEntity || null != userPromotionAccountEntity) {
            this.merchantUserPromotionAccountMapper.deleteByPrimaryKey(userPromotionAccountEntity.getId());
        }
        List listInviteHistory = (List)this.userFeignService.getInviteHistoryListByUid(userId).getBody();
        AtomicLong totalAccount = new AtomicLong(0L);
        if (!CollectionUtils.isEmpty((Collection)listInviteHistory)) {
            Long merchantId = merchantInfo.getId();
            ArrayList listFlowEntity = new ArrayList(listInviteHistory.size());
            ArrayList listInviteEntity = new ArrayList(listInviteHistory.size());
            listInviteHistory.forEach(userInviteHistoryDTO -> {
                UserInviteHistoryEntity inviteHistoryEntity = new UserInviteHistoryEntity();
                BeanUtils.copyProperties((Object)userInviteHistoryDTO, (Object)inviteHistoryEntity);
                inviteHistoryEntity.setId(this.sequenceCreater.nextLongId());
                listInviteEntity.add(inviteHistoryEntity);
                MerchantPromotionFlowEntity flowEntity = new MerchantPromotionFlowEntity();
                flowEntity.setUserId(userId);
                flowEntity.setMerchantId(merchantId);
                Integer levelMaster = Objects.equals(userInviteHistoryDTO.getInviteUserId(), userId) || Objects.equals(userInviteHistoryDTO.getCreatedUserId(), userId) ? 1 : 2;
                flowEntity.setAmount(levelMaster == 1 ? this.merchantProAccountProperties.getMasterMoney() : this.merchantProAccountProperties.getMasterTwoMoney());
                flowEntity.setRelationId(Long.valueOf(null == flowEntity.getRelationId() ? 0L : flowEntity.getRelationId()));
                flowEntity.setRelationTitle(levelMaster == 1 ? MerchantAccountTypeEnum.INVITE_ONE_FRIEND.getTitle() : MerchantAccountTypeEnum.INVITE_TWO_FRIEND.getTitle());
                flowEntity.setType(levelMaster == 1 ? MerchantAccountTypeEnum.INVITE_ONE_FRIEND.name() : MerchantAccountTypeEnum.INVITE_TWO_FRIEND.name());
                flowEntity.setRemark("initdata");
                flowEntity.setId(this.sequenceCreater.nextLongId());
                listFlowEntity.add(flowEntity);
                totalAccount.addAndGet(flowEntity.getAmount().multiply(new BigDecimal("100")).longValue());
            });
            this.merchantUserPromotionFlowMapper.batchInsertEntity(listFlowEntity);
            this.userInviteHistoryMapper.batchInsert(listInviteEntity);
        }
        userPromotionAccountEntity = new MerchantUserPromotionAccountEntity();
        userPromotionAccountEntity.setMerchantId(merchantInfo.getId());
        userPromotionAccountEntity.setVersion(Integer.valueOf(0));
        userPromotionAccountEntity.setAblePromotionCash(new BigDecimal(totalAccount.get()).divide(new BigDecimal("100")));
        userPromotionAccountEntity.setTotalPromotionCash(new BigDecimal(totalAccount.get()).divide(new BigDecimal("100")));
        userPromotionAccountEntity.setConsumePromotionCash(BigDecimal.ZERO);
        userPromotionAccountEntity.setFreezePromotionCash(BigDecimal.ZERO);
        userPromotionAccountEntity.setCreateTime(new Date());
        if (userPromotionAccountEntity.getTotalPromotionCash().compareTo(this.merchantProAccountProperties.getMaxLimit()) >= 0) {
            userPromotionAccountEntity.setTotalPromotionCash(this.merchantProAccountProperties.getMaxLimit());
            userPromotionAccountEntity.setAblePromotionCash(this.merchantProAccountProperties.getMaxLimit());
        }
        this.merchantUserPromotionAccountMapper.insertSelective(userPromotionAccountEntity);
        return true;
    }

    private void convert(MerchantUserAccountVO userAccountVO, MerchantAccountEntity accountEntity) {
        if (null == accountEntity) {
            userAccountVO.setTotalCash(new BigDecimal(0));
            userAccountVO.setDrawableCash(new BigDecimal(0));
            userAccountVO.setFreezeCash(new BigDecimal(0));
            userAccountVO.setWithdrawedCash(new BigDecimal(0));
            userAccountVO.setWithdrawingCash(new BigDecimal(0));
            userAccountVO.setVersionCash(Integer.valueOf(-1));
        } else {
            userAccountVO.setTotalCash(accountEntity.getTotalCash());
            userAccountVO.setDrawableCash(accountEntity.getDrawableCash());
            userAccountVO.setFreezeCash(accountEntity.getFreezeCash());
            userAccountVO.setWithdrawedCash(accountEntity.getWithdrawedCash());
            userAccountVO.setWithdrawingCash(accountEntity.getWithdrawingCash());
            userAccountVO.setVersionCash(accountEntity.getVersion());
        }
    }

    private void convert(MerchantUserAccountVO userAccountVO, MerchantUserPromotionAccountEntity accountEntity) {
        if (null == accountEntity) {
            userAccountVO.setTotalProCash(new BigDecimal(0));
            userAccountVO.setAbleProCash(new BigDecimal(0));
            userAccountVO.setFreezeProCash(new BigDecimal(0));
            userAccountVO.setConsumeProCash(new BigDecimal(0));
            userAccountVO.setVersionProCash(Integer.valueOf(-1));
        } else {
            userAccountVO.setTotalProCash(accountEntity.getTotalPromotionCash());
            userAccountVO.setAbleProCash(accountEntity.getAblePromotionCash());
            userAccountVO.setFreezeProCash(accountEntity.getFreezePromotionCash());
            userAccountVO.setConsumeProCash(accountEntity.getConsumePromotionCash());
            userAccountVO.setVersionProCash(accountEntity.getVersion());
        }
    }

    public MerchantUserProAccountServiceImpl(RedisHashMapAdapter redisHashMapAdapter, MerchantAccountMapper merchantAccountMapper, MerchantUserPromotionAccountMapper merchantUserPromotionAccountMapper, MerchantUserPromotionFlowMapper merchantUserPromotionFlowMapper, MerchantInfoMapper merchantInfoMapper, UserFeignService userFeignService, MerchantProAccountProperties merchantProAccountProperties, UserInviteHistoryMapper userInviteHistoryMapper, SequenceCreater sequenceCreater) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.merchantAccountMapper = merchantAccountMapper;
        this.merchantUserPromotionAccountMapper = merchantUserPromotionAccountMapper;
        this.merchantUserPromotionFlowMapper = merchantUserPromotionFlowMapper;
        this.merchantInfoMapper = merchantInfoMapper;
        this.userFeignService = userFeignService;
        this.merchantProAccountProperties = merchantProAccountProperties;
        this.userInviteHistoryMapper = userInviteHistoryMapper;
        this.sequenceCreater = sequenceCreater;
    }
}

