/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.timer;

import com.bxm.localnews.merchant.security.facade.vo.MerchantMemberVo;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.service.count.MerchantMemberCounterService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MerchantClickReportTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(MerchantClickReportTask.class);
    @Autowired
    private MerchantMemberCounterService merchantMemberCounterService;
    @Autowired
    private PushIntegrationService pushIntegrationService;

    public ReturnT<String> service(String s) {
        List<MerchantMemberVo> listMember = this.merchantMemberCounterService.getAllSyncPushList();
        if (!CollectionUtils.isEmpty(listMember)) {
            for (MerchantMemberVo merchantMemberVo : listMember) {
                log.info("\u70b9\u51fb\u6d88\u606f\u6570\u636e>>>>uid:{},merchantId:{}", (Object)merchantMemberVo.getUserId(), (Object)merchantMemberVo.getMerchantId());
                this.pushIntegrationService.pushShareByClickReport(merchantMemberVo);
            }
            this.merchantMemberCounterService.removeAllSyncPushList();
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "\u6bcf10\u5206\u949f\u7ed9\u8001\u677f/\u5458\u5de5\u53d1\u9001\u70b9\u51fbpush";
    }

    public String cron() {
        return "0 */10 * ? * *";
    }
}

