/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchants.dto.MerchantChannelInfo;
import com.bxm.localnews.merchants.dto.MerchantCollectInfoDetailDTO;
import com.bxm.localnews.merchants.dto.MerchantDetailDTO;
import com.bxm.localnews.merchants.dto.MerchantWorkListDTO;
import com.bxm.localnews.merchants.dto.MerchantWorkV2ListDTO;
import com.bxm.localnews.merchants.param.CollectMerchantParam;
import com.bxm.localnews.merchants.param.MerChantListParam;
import com.bxm.localnews.merchants.param.MerchantCollectListParam;
import com.bxm.localnews.merchants.param.MerchantDetailParam;
import com.bxm.localnews.merchants.service.MerchantCollectService;
import com.bxm.localnews.merchants.service.MerchantListService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"11-01 \u5546\u6237\u9762\u5411C\u7aef\u7528\u6237\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/merchant/work"})
public class MerchantWorkController {
    private final MerchantListService merchantListService;
    private final MerchantCollectService merchantCollectService;

    @Autowired
    public MerchantWorkController(MerchantListService merchantListService, MerchantCollectService merchantCollectService) {
        this.merchantListService = merchantListService;
        this.merchantCollectService = merchantCollectService;
    }

    @GetMapping(value={"/merchantListInfo"})
    @ApiOperation(value="11-01-1 [v1]\u5546\u6237\u5217\u8868", notes="\u5546\u6237\u5217\u8868\u4fe1\u606f")
    @ApiVersion(value=1)
    public ResponseJson<PageWarper<MerchantWorkListDTO>> merchantListInfo(MerChantListParam param) {
        return ResponseJson.ok((Object)this.merchantListService.getMerchantList(param));
    }

    @GetMapping(value={"merchantDetailInfo"})
    @ApiOperation(value="11-01-2 [v1]\u83b7\u53d6\u5546\u5bb6\u8be6\u60c5\u4fe1\u606f", notes="\u83b7\u53d6\u5546\u5bb6\u8be6\u60c5\u4fe1\u606f")
    @ApiVersion(value=1)
    public ResponseJson<MerchantDetailDTO> merchantDetailInfo(MerchantDetailParam param) {
        return ResponseJson.ok((Object)this.merchantListService.getMerchantDetail(param));
    }

    @PostMapping(value={"collectMerchant"})
    @ApiOperation(value="11-01-3 [v1]\u6536\u85cf/\u53d6\u6d88\u6536\u85cf", notes="\u6536\u85cf/\u53d6\u6d88\u6536\u85cf\u5546\u5bb6")
    @ApiVersion(value=1)
    public ResponseJson<Boolean> collectMerchant(@RequestBody CollectMerchantParam param) {
        return ResponseJson.ok((Object)this.merchantCollectService.collectMerchant(param));
    }

    @GetMapping(value={"merchantCollectInfo"})
    @ApiOperation(value="11-01-4 [v1]\u5546\u5bb6\u6536\u85cf\u5217\u8868", notes="\u5546\u5bb6\u6536\u85cf\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @ApiVersion(value=1)
    public ResponseJson<PageWarper<MerchantCollectInfoDetailDTO>> merchantCollectInfo(MerchantCollectListParam param) {
        return ResponseJson.ok((Object)this.merchantCollectService.getCollectList(param));
    }

    @GetMapping(value={"/merchantCategoryListInfo"})
    @ApiOperation(value="11-01-5 [v1]\u9891\u9053\u9875\u4e0b\u7684\u7279\u6b8a\u7f6e\u9876\u5546\u5bb6", notes="\u9891\u9053\u9875\u4e0b\u7684\u7279\u6b8a\u7f6e\u9876\u5546\u5bb6")
    @ApiVersion(value=1)
    public ResponseJson<List<MerchantChannelInfo>> channelSortMerchant(MerChantListParam param) {
        return ResponseJson.ok((Object)this.merchantListService.getChannelQuMerchantList(param));
    }

    @GetMapping(value={"/merchantListInfo"})
    @ApiOperation(value="11-01-6 [v2]\u5546\u6237\u4fbf\u6c11\u5217\u8868", notes="\u5546\u6237\u4fbf\u6c11\u5217\u8868")
    @ApiVersion(value=2)
    public ResponseJson<PageWarper<MerchantWorkV2ListDTO>> merchantListInfoV2(MerChantListParam param) {
        return ResponseJson.ok((Object)this.merchantListService.merchantListInfoV2(param));
    }
}

