/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchants.dto.IntoApplyDTO;
import com.bxm.localnews.merchants.dto.MerchantBusinessInfo;
import com.bxm.localnews.merchants.dto.MerchantInfoDto;
import com.bxm.localnews.merchants.dto.MerchantStatusDto;
import com.bxm.localnews.merchants.param.ClickCenterParam;
import com.bxm.localnews.merchants.param.MerchantAuthInfoParam;
import com.bxm.localnews.merchants.param.MerchantInfoParam;
import com.bxm.localnews.merchants.param.MerchantIntoApplyParam;
import com.bxm.localnews.merchants.param.MerchantIntoInfoDto;
import com.bxm.localnews.merchants.param.MerchantStatusParam;
import com.bxm.localnews.merchants.service.MerchantInfoService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={" 11-03 \u5546\u6237\u76f8\u5173API"})
@RestController
@RequestMapping(value={"{version}/merchant/info"})
public class MerchantInfoController {
    private final MerchantInfoService merchantInfoService;

    @Autowired
    public MerchantInfoController(MerchantInfoService merchantInfoService) {
        this.merchantInfoService = merchantInfoService;
    }

    @ApiOperation(value="11-03-1 \u3010v1\u3011\u83b7\u53d6\u5e97\u94fa\u72b6\u6001\u4fe1\u606f,\u663e\u793a\u4e0d\u540c\u7684\u6587\u6848,\u8df3\u8f6c\u4e0d\u540c\u7684\u9875\u9762", notes="\u672a\u5b8c\u6210\u8d44\u8d28\u8ba4\u8bc1\u6587\u6848\u4e3a\u201c\u5546\u5bb6\u5408\u4f5c,\u5b8c\u6210\u8d44\u8d28\u8ba4\u8bc1\u6587\u6848\u4e3a\u201c\u5546\u5bb6\u4e2d\u5fc3,\u672a\u7533\u8bf7\u5165\u9a7b\u70b9\u51fb\u8fdb\u5165\u5165\u9a7b\u7533\u8bf7\u9875\u9762,\u5df2\u7533\u8bf7\u5165\u9a7b\u70b9\u51fb\u8fdb\u5165\u5546\u5bb6\u4e2d\u5fc3", httpMethod="GET", nickname="\u5468\u91d1\u6210")
    @GetMapping(value={"/status"})
    @ApiVersion(value=1)
    public ResponseJson<MerchantStatusDto> getStatus(MerchantStatusParam param) {
        return ResponseJson.ok((Object)this.merchantInfoService.getStatus(param));
    }

    @ApiOperation(value="11-03-2 \u3010v1\u3011\u63d0\u4ea4\u5165\u9a7b\u4fe1\u606f", notes="\u63d0\u4ea4\u5165\u9a7b\u4fe1\u606f", httpMethod="POST", nickname="\u5468\u91d1\u6210")
    @PostMapping(value={"/intoApply"})
    @ApiVersion(value=1)
    public ResponseJson<IntoApplyDTO> intoApply(@RequestBody @Validated MerchantIntoApplyParam merchantIntoApplyParam) {
        Message message = this.merchantInfoService.enter(merchantIntoApplyParam);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("intoApplyDTO"));
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-03-3 \u3010v1\u3011\u83b7\u53d6\u5165\u9a7b\u4fe1\u606f", notes="\u83b7\u53d6\u5165\u9a7b\u4fe1\u606f", httpMethod="GET", nickname="\u5468\u91d1\u6210")
    @GetMapping(value={"/getIntoInfo"})
    @ApiVersion(value=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true)})
    public ResponseJson<MerchantIntoInfoDto> getIntoInfo(@RequestParam(value="merchantId") Long merchantId) {
        return ResponseJson.ok((Object)this.merchantInfoService.getMerchantInfo(merchantId));
    }

    @ApiOperation(value="11-03-4 \u3010v1\u3011\u63d0\u4ea4\u8d44\u8d28\u4fe1\u606f", notes="\u63d0\u4ea4\u8d44\u8d28\u4fe1\u606f", httpMethod="POST", nickname="\u5468\u91d1\u6210")
    @PostMapping(value={"/authApply"})
    @ApiVersion(value=1)
    public ResponseJson authInfo(@RequestBody @Validated MerchantAuthInfoParam merchantAuthInfoParam) {
        return ResponseJson.build((Message)this.merchantInfoService.authApply(merchantAuthInfoParam));
    }

    @ApiOperation(value="11-03-5 \u3010v1\u3011\u5e97\u94fa\u88c5\u4fee", notes="\u66f4\u65b0\u5546\u5bb6\u4fe1\u606f", httpMethod="POST", nickname="\u5468\u91d1\u6210")
    @PostMapping(value={"/saveMerchantInfo"})
    @ApiVersion(value=1)
    public ResponseJson updateMerchantInfo(@RequestBody @Validated MerchantInfoParam merchantInfoParam) {
        return ResponseJson.build((Message)this.merchantInfoService.updateMerchantInfo(merchantInfoParam));
    }

    @ApiOperation(value="11-03-6 \u3010v1\u3011\u5e97\u94fa\u8be6\u60c5\u548c\u5fae\u5b98\u7f51\u4fe1\u606f", notes="\u83b7\u53d6\u5e97\u94fa\u57fa\u672c\u4fe1\u606f", httpMethod="GET", nickname="\u5468\u91d1\u6210")
    @GetMapping(value={"/getMerchantInfo"})
    @ApiVersion(value=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true)})
    public ResponseJson<MerchantInfoDto> getMerchantInfo(@RequestParam(value="merchantId") Long merchantId) {
        Message message = this.merchantInfoService.getMerchantInfoDetail(merchantId);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("merchantInfoDto"));
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-03-7 \u3010v1\u3011\u83b7\u53d6\u5546\u5bb6\u4e2d\u5fc3\u57fa\u672c\u4fe1\u606f", notes="\u83b7\u53d6\u5546\u5bb6\u8d44\u8d28,\u88c5\u4fee,\u53ef\u7528\u63a8\u5e7f\u91d1,\u662f\u5426\u8fdb\u5165\u4f1a\u5458\u4e2d\u5fc3\u4fe1\u606f", httpMethod="GET", nickname="\u5468\u91d1\u6210")
    @GetMapping(value={"/getBusinessInfo"})
    @ApiVersion(value=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="merchantId", value="\u5546\u6237id", required=true)})
    public ResponseJson<MerchantBusinessInfo> getBusinessInfo(@RequestParam(value="merchantId") Long merchantId) {
        Message message = this.merchantInfoService.getBusinessInfo(merchantId);
        if (message.isSuccess()) {
            return ResponseJson.ok((Object)message.getParam("merchantBusinessInfo"));
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="11-03-8 \u3010v1\u3011\u70b9\u51fb\u8fdb\u5165\u4f1a\u5458\u4e2d\u5fc3\u9875\u9762", notes="\u8fdb\u5165\u4f1a\u5458\u4e2d\u5fc3\u52a0\u6807\u8bb0,\u7b2c\u4e00\u6b21\u8fdb\u5165redis\u5199\u5165key\u4e3a\u5546\u6237id,\u5224\u65adkey\u7684\u503c\u6765\u786e\u5b9a\u662f\u5426\u4e3a\u7b2c\u4e00\u6b21\u8fdb\u5165", httpMethod="POST", nickname="\u5468\u91d1\u6210")
    @PostMapping(value={"/clickCenter"})
    @ApiVersion(value=1)
    public ResponseJson clickCenter(@RequestBody ClickCenterParam clickCenterParam) {
        this.merchantInfoService.clickCenter(clickCenterParam.getMerchantId());
        return ResponseJson.ok((Object)Boolean.TRUE);
    }
}

