package com.bxm.localnews.merchants.facade.service;


import com.bxm.localnews.merchants.dto.MerchantInfoDto;
import com.bxm.localnews.merchants.vo.MerchantInfo;

/**
 * @author: pf.w
 * @date: 2020/9/27 18:12
 **/
public interface MerchantInfoFacadeService {
    /**
     * 保存商家信息
     *
     * @param info 商家实体
     * @return 成功 ：true | 失败 ：false
     */
    boolean saveMerchant(MerchantInfo info);


    /**
     * 更新商家信息
     *
     * @param info 商家实体
     * @return 成功 ：true | 失败 ：false
     */
    boolean updateMerchant(MerchantInfo info);

    /**
     * 根据用户Id 删除商家信息
     *
     * @param userId ： 用户id
     * @return ： 返回结果
     */
    boolean deleteMerchantInfoByUid(Long userId);

    /**
     * 获取商家详情 (详情库里的全部信息)
     *
     * @param merchantId 商家ID
     * @return 商家详情实体
     */
    MerchantInfo getMerchantInfo(Long merchantId);

    /**
     * 获取商家的信息(截取过头图操作等，返回DTO详情实体)
     *
     * @param merchantId 商家ID
     * @return 商家信息
     */
    MerchantInfoDto getMerchantInfoDetail(Long merchantId);
}
