package com.bxm.localnews.merchants.facade.service;


import com.bxm.localnews.merchants.dto.MerchantUserDTO;

/**
 * @author: pf.w
 * @date: 2020/9/27 19:45
 **/
public interface MerchantRedisRefreshFacade {
    /**
     * 刷新商家列表缓存（商家下架时，注册成为会员时，便民商家列表编辑保存时，刷新）
     *
     * @param merchantId 商家ID
     */
    void refreshMerchantList(Long merchantId);

    /**
     * 删除地区缓存数据
     *
     * @param areaCode   地区编码
     * @param categoryId 分类ID
     */
    void removeMerchantList(String areaCode, Long categoryId);

    /**
     * 商户信息变更时，移除缓存信息
     *
     * @param userId 移除商户的缓存信息
     */
    void removeMerchantUserCache(Long userId);

    /**
     * 初始化商户缓存信息
     * 将审核通过的商户更新到缓存
     */
    void initCache();

    /**
     * 获取商户信息的缓存对象
     *
     * @param userId 商户对应的用户ID
     * @return 商户的用户信息
     */
    MerchantUserDTO getMerchantUserCache(Long userId);
}
