package com.bxm.localnews.merchants.cache.collected;

import com.bxm.localnews.merchants.vo.MerchantCollectedVo;

import java.util.List;

/**
 *
 * 商家收藏缓存相关
 *
 * @author pf.w
 * @date 2020/9/22 17:36
 **/
public interface MerchantCollectRedisRefresh {


    /**
     * 获取缓存用户收藏的商家ids
     *
     * @param userId 用不id
     * @return 收藏的商家ids
     */
    List<MerchantCollectedVo> getCollectedMerchants(Long userId);

    /**
     * 根据缓存的收藏信息判断用户对某个商家的收藏状态
     *
     * @param userId 用户ID
     * @param merchantId 目标商家ID
     * @return 返回收藏结果  true : 已收藏  | false : 未收藏
     */
    boolean checkMerchantIsCollected(Long userId,Long merchantId);

    /**
     * 刷新收藏列表缓存
     *
     * @param userId 收藏商品的用户ID
     */
    void refreshMerchantCollect(Long userId);

    /**
     * load info from db and save to redis
     * @param userId 用户ID
     * @return 收藏列表
     */
    List<MerchantCollectedVo> loadInfoFromDb(Long userId);
}
