package com.bxm.localnews.merchants.cache.detail;

import com.bxm.localnews.merchants.dto.MerchantInfoCacheDTO;
import com.bxm.localnews.merchants.vo.MerchantInfo;

/**
 * 商家详情缓存相关
 *
 * @author: pf.w
 * @date: 2020/9/24 17:49
 **/
public interface MerchantInfoRedisRefresh {

    /**
     * 获取商家详情缓存信息+分类名称
     *
     * @param merchantId 商家ID
     * @return 商家详情实体bean + 分类名称
     */
    MerchantInfoCacheDTO getMerchantInfoCache(Long merchantId);

    /**
     * 获取商家详情缓存信息
     *
     * <p>
     * (因为很多地方直接取的是MerchantInfo对象，所以这边多做一部转化)
     * </p>
     *
     * @param merchantId 商家ID
     * @return 商家详情实体bean
     */
    MerchantInfo getMerchantInfo(Long merchantId);

    /**
     * 异步刷新商家缓存
     *
     * @param merchantId 商家Id
     */
    void merchantInfoRefresh(Long merchantId);
}
