package com.bxm.localnews.merchants.manage;

import com.bxm.localnews.merchant.dto.MechantTeamInfosDTO;
import com.bxm.localnews.merchant.param.AuditAuthInfoParam;
import com.bxm.localnews.merchant.param.ManageMerchantInfoAddParam;
import com.bxm.localnews.merchant.param.ManageMerchantInfoParam;
import com.bxm.localnews.merchant.param.MerchantAdvertParam;
import com.bxm.localnews.merchant.param.manager.MemberTeamParam;
import com.bxm.localnews.merchants.dto.MerchantAdvertInfoDTO;
import com.bxm.localnews.merchants.param.MerchantManageListParam;
import com.bxm.localnews.merchants.vo.MerchantInfoListVo;
import com.bxm.localnews.merchants.vo.MerchantMatchVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author zhoujincheng
 * @date 2020-07-14 11:02
 */
public interface MerchantInfoManageService {

    /**
     * 获取到商户的审核信息
     *
     * @param merchantId 商户ID
     * @return 商户审核的基本信息
     */
    Message getAuthInfo(Long merchantId);

    /**
     * 资质审核
     *
     * @param auditAuthInfoParam 审核信息上行参数
     * @return 资质审核是否成功  店铺上下架状态改变 缓存更新 app消息推送等
     */
    Message auditAuthInfo(AuditAuthInfoParam auditAuthInfoParam);

    /**
     * 添加商户备注
     *
     * @param merchantId 商户ID
     * @param remark     备注信息
     */
    void addMerchantRemark(Long merchantId, String remark);

    /**
     * 获取到商户信息
     *
     * @param merchantId 商家ID
     * @return 商户基本信息
     */
    Message getMerchantInfo(Long merchantId);

    /**
     * 保存商户信息
     *
     * @param manageMerchantInfoParam 商户基本信息实体
     * @return 是否成功
     */
    Message saveMerchantInfo(ManageMerchantInfoParam manageMerchantInfoParam);

    /**
     * 获取到商户列表
     *
     * @param merchantManageListParam 查询条件包括商户名等
     * @return 商户列表
     */
    PageWarper<MerchantInfoListVo> getMerchantList(MerchantManageListParam merchantManageListParam);

    /**
     * 新增商户  后台新增商户 需要运营手动绑定用户id
     *
     * @param manageMerchantInfoAddParam 商户信息
     * @return 保存结果信息
     */
    Message insertMerchantInfo(ManageMerchantInfoAddParam manageMerchantInfoAddParam);

    /**
     * 获取商家广告详情
     *
     * @param merchantId 商户ID
     * @return 商户广告信息
     */
    MerchantAdvertInfoDTO merchantAdvertInfo(Long merchantId);

    /**
     * 修改保存商家广告
     *
     * @param param 商家广告信息实体
     * @return 操作结果
     */
    Boolean editMerchantAdvert(MerchantAdvertParam param);

    /**
     * 商家团队成员信息
     *
     * @param param 查询上行参数
     * @return 商家团队成员信息分页列表数据
     */
    PageWarper<MechantTeamInfosDTO> getMemberInfo(MemberTeamParam param);

    /**
     * 批量导入员工接口
     *
     * @param file 文件信息
     */
    void readExcel(MultipartFile file);

    /**
     * 模糊匹配商户通过商户名称
     *
     * @param merchantName 商户名称
     * @return 商户信息列表
     */
    List<MerchantMatchVO> matchMerchantInfoByName(String merchantName);

}
